// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.costmanagement.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.OffsetDateTime;

/**
 * The properties of the benefit recommendations.
 */
@Fluent
public class BenefitRecommendationProperties implements JsonSerializable<BenefitRecommendationProperties> {
    /*
     * Benefit scope. For example, Single or Shared.
     */
    private Scope scope = Scope.fromString("BenefitRecommendationProperties");

    /*
     * The first usage date used for looking back for computing the recommendations.
     */
    private OffsetDateTime firstConsumptionDate;

    /*
     * The last usage date used for looking back for computing the recommendations.
     */
    private OffsetDateTime lastConsumptionDate;

    /*
     * The number of days of usage evaluated for computing the recommendations.
     */
    private LookBackPeriod lookBackPeriod;

    /*
     * The total hours for which the cost is covered. Its equal to number of records in a property
     * 'properties/usage/charges'.
     */
    private Integer totalHours;

    /*
     * On-demand charges between firstConsumptionDate and lastConsumptionDate that were used for computing benefit
     * recommendations.
     */
    private RecommendationUsageDetails usage;

    /*
     * ARM SKU name. 'Compute_Savings_Plan' for SavingsPlan.
     */
    private String armSkuName;

    /*
     * Term period of the benefit. For example, P1Y or P3Y.
     */
    private Term term;

    /*
     * Grain of the proposed commitment amount. Supported values: 'Hourly'
     */
    private Grain commitmentGranularity;

    /*
     * An ISO 4217 currency code identifier for the costs and savings amounts.
     */
    private String currencyCode;

    /*
     * The current cost without benefit, corresponds to 'totalHours' in the look-back period.
     */
    private BigDecimal costWithoutBenefit;

    /*
     * The details of the proposed recommendation.
     */
    private AllSavingsBenefitDetails recommendationDetails;

    /*
     * The list of all benefit recommendations with the recommendation details.
     */
    private AllSavingsList allRecommendationDetails;

    /**
     * Creates an instance of BenefitRecommendationProperties class.
     */
    public BenefitRecommendationProperties() {
    }

    /**
     * Get the scope property: Benefit scope. For example, Single or Shared.
     * 
     * @return the scope value.
     */
    public Scope scope() {
        return this.scope;
    }

    /**
     * Get the firstConsumptionDate property: The first usage date used for looking back for computing the
     * recommendations.
     * 
     * @return the firstConsumptionDate value.
     */
    public OffsetDateTime firstConsumptionDate() {
        return this.firstConsumptionDate;
    }

    /**
     * Set the firstConsumptionDate property: The first usage date used for looking back for computing the
     * recommendations.
     * 
     * @param firstConsumptionDate the firstConsumptionDate value to set.
     * @return the BenefitRecommendationProperties object itself.
     */
    BenefitRecommendationProperties withFirstConsumptionDate(OffsetDateTime firstConsumptionDate) {
        this.firstConsumptionDate = firstConsumptionDate;
        return this;
    }

    /**
     * Get the lastConsumptionDate property: The last usage date used for looking back for computing the
     * recommendations.
     * 
     * @return the lastConsumptionDate value.
     */
    public OffsetDateTime lastConsumptionDate() {
        return this.lastConsumptionDate;
    }

    /**
     * Set the lastConsumptionDate property: The last usage date used for looking back for computing the
     * recommendations.
     * 
     * @param lastConsumptionDate the lastConsumptionDate value to set.
     * @return the BenefitRecommendationProperties object itself.
     */
    BenefitRecommendationProperties withLastConsumptionDate(OffsetDateTime lastConsumptionDate) {
        this.lastConsumptionDate = lastConsumptionDate;
        return this;
    }

    /**
     * Get the lookBackPeriod property: The number of days of usage evaluated for computing the recommendations.
     * 
     * @return the lookBackPeriod value.
     */
    public LookBackPeriod lookBackPeriod() {
        return this.lookBackPeriod;
    }

    /**
     * Set the lookBackPeriod property: The number of days of usage evaluated for computing the recommendations.
     * 
     * @param lookBackPeriod the lookBackPeriod value to set.
     * @return the BenefitRecommendationProperties object itself.
     */
    public BenefitRecommendationProperties withLookBackPeriod(LookBackPeriod lookBackPeriod) {
        this.lookBackPeriod = lookBackPeriod;
        return this;
    }

    /**
     * Get the totalHours property: The total hours for which the cost is covered. Its equal to number of records in a
     * property 'properties/usage/charges'.
     * 
     * @return the totalHours value.
     */
    public Integer totalHours() {
        return this.totalHours;
    }

    /**
     * Set the totalHours property: The total hours for which the cost is covered. Its equal to number of records in a
     * property 'properties/usage/charges'.
     * 
     * @param totalHours the totalHours value to set.
     * @return the BenefitRecommendationProperties object itself.
     */
    BenefitRecommendationProperties withTotalHours(Integer totalHours) {
        this.totalHours = totalHours;
        return this;
    }

    /**
     * Get the usage property: On-demand charges between firstConsumptionDate and lastConsumptionDate that were used for
     * computing benefit recommendations.
     * 
     * @return the usage value.
     */
    public RecommendationUsageDetails usage() {
        return this.usage;
    }

    /**
     * Set the usage property: On-demand charges between firstConsumptionDate and lastConsumptionDate that were used for
     * computing benefit recommendations.
     * 
     * @param usage the usage value to set.
     * @return the BenefitRecommendationProperties object itself.
     */
    public BenefitRecommendationProperties withUsage(RecommendationUsageDetails usage) {
        this.usage = usage;
        return this;
    }

    /**
     * Get the armSkuName property: ARM SKU name. 'Compute_Savings_Plan' for SavingsPlan.
     * 
     * @return the armSkuName value.
     */
    public String armSkuName() {
        return this.armSkuName;
    }

    /**
     * Set the armSkuName property: ARM SKU name. 'Compute_Savings_Plan' for SavingsPlan.
     * 
     * @param armSkuName the armSkuName value to set.
     * @return the BenefitRecommendationProperties object itself.
     */
    BenefitRecommendationProperties withArmSkuName(String armSkuName) {
        this.armSkuName = armSkuName;
        return this;
    }

    /**
     * Get the term property: Term period of the benefit. For example, P1Y or P3Y.
     * 
     * @return the term value.
     */
    public Term term() {
        return this.term;
    }

    /**
     * Set the term property: Term period of the benefit. For example, P1Y or P3Y.
     * 
     * @param term the term value to set.
     * @return the BenefitRecommendationProperties object itself.
     */
    public BenefitRecommendationProperties withTerm(Term term) {
        this.term = term;
        return this;
    }

    /**
     * Get the commitmentGranularity property: Grain of the proposed commitment amount. Supported values: 'Hourly'.
     * 
     * @return the commitmentGranularity value.
     */
    public Grain commitmentGranularity() {
        return this.commitmentGranularity;
    }

    /**
     * Set the commitmentGranularity property: Grain of the proposed commitment amount. Supported values: 'Hourly'.
     * 
     * @param commitmentGranularity the commitmentGranularity value to set.
     * @return the BenefitRecommendationProperties object itself.
     */
    public BenefitRecommendationProperties withCommitmentGranularity(Grain commitmentGranularity) {
        this.commitmentGranularity = commitmentGranularity;
        return this;
    }

    /**
     * Get the currencyCode property: An ISO 4217 currency code identifier for the costs and savings amounts.
     * 
     * @return the currencyCode value.
     */
    public String currencyCode() {
        return this.currencyCode;
    }

    /**
     * Set the currencyCode property: An ISO 4217 currency code identifier for the costs and savings amounts.
     * 
     * @param currencyCode the currencyCode value to set.
     * @return the BenefitRecommendationProperties object itself.
     */
    BenefitRecommendationProperties withCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
        return this;
    }

    /**
     * Get the costWithoutBenefit property: The current cost without benefit, corresponds to 'totalHours' in the
     * look-back period.
     * 
     * @return the costWithoutBenefit value.
     */
    public BigDecimal costWithoutBenefit() {
        return this.costWithoutBenefit;
    }

    /**
     * Set the costWithoutBenefit property: The current cost without benefit, corresponds to 'totalHours' in the
     * look-back period.
     * 
     * @param costWithoutBenefit the costWithoutBenefit value to set.
     * @return the BenefitRecommendationProperties object itself.
     */
    BenefitRecommendationProperties withCostWithoutBenefit(BigDecimal costWithoutBenefit) {
        this.costWithoutBenefit = costWithoutBenefit;
        return this;
    }

    /**
     * Get the recommendationDetails property: The details of the proposed recommendation.
     * 
     * @return the recommendationDetails value.
     */
    public AllSavingsBenefitDetails recommendationDetails() {
        return this.recommendationDetails;
    }

    /**
     * Set the recommendationDetails property: The details of the proposed recommendation.
     * 
     * @param recommendationDetails the recommendationDetails value to set.
     * @return the BenefitRecommendationProperties object itself.
     */
    public BenefitRecommendationProperties withRecommendationDetails(AllSavingsBenefitDetails recommendationDetails) {
        this.recommendationDetails = recommendationDetails;
        return this;
    }

    /**
     * Get the allRecommendationDetails property: The list of all benefit recommendations with the recommendation
     * details.
     * 
     * @return the allRecommendationDetails value.
     */
    public AllSavingsList allRecommendationDetails() {
        return this.allRecommendationDetails;
    }

    /**
     * Set the allRecommendationDetails property: The list of all benefit recommendations with the recommendation
     * details.
     * 
     * @param allRecommendationDetails the allRecommendationDetails value to set.
     * @return the BenefitRecommendationProperties object itself.
     */
    BenefitRecommendationProperties withAllRecommendationDetails(AllSavingsList allRecommendationDetails) {
        this.allRecommendationDetails = allRecommendationDetails;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (usage() != null) {
            usage().validate();
        }
        if (recommendationDetails() != null) {
            recommendationDetails().validate();
        }
        if (allRecommendationDetails() != null) {
            allRecommendationDetails().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("scope", this.scope == null ? null : this.scope.toString());
        jsonWriter.writeStringField("lookBackPeriod",
            this.lookBackPeriod == null ? null : this.lookBackPeriod.toString());
        jsonWriter.writeJsonField("usage", this.usage);
        jsonWriter.writeStringField("term", this.term == null ? null : this.term.toString());
        jsonWriter.writeStringField("commitmentGranularity",
            this.commitmentGranularity == null ? null : this.commitmentGranularity.toString());
        jsonWriter.writeJsonField("recommendationDetails", this.recommendationDetails);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of BenefitRecommendationProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of BenefitRecommendationProperties if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the BenefitRecommendationProperties.
     */
    public static BenefitRecommendationProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject()) {
                readerToUse.nextToken(); // Prepare for reading
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("scope".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    } else {
                        readerToUse.skipChildren();
                    }
                }
                // Use the discriminator value to determine which subtype should be deserialized.
                if ("Single".equals(discriminatorValue)) {
                    return SingleScopeBenefitRecommendationProperties.fromJson(readerToUse.reset());
                } else if ("Shared".equals(discriminatorValue)) {
                    return SharedScopeBenefitRecommendationProperties.fromJson(readerToUse.reset());
                } else {
                    return fromJsonKnownDiscriminator(readerToUse.reset());
                }
            }
        });
    }

    static BenefitRecommendationProperties fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            BenefitRecommendationProperties deserializedBenefitRecommendationProperties
                = new BenefitRecommendationProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("scope".equals(fieldName)) {
                    deserializedBenefitRecommendationProperties.scope = Scope.fromString(reader.getString());
                } else if ("firstConsumptionDate".equals(fieldName)) {
                    deserializedBenefitRecommendationProperties.firstConsumptionDate = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("lastConsumptionDate".equals(fieldName)) {
                    deserializedBenefitRecommendationProperties.lastConsumptionDate = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("lookBackPeriod".equals(fieldName)) {
                    deserializedBenefitRecommendationProperties.lookBackPeriod
                        = LookBackPeriod.fromString(reader.getString());
                } else if ("totalHours".equals(fieldName)) {
                    deserializedBenefitRecommendationProperties.totalHours = reader.getNullable(JsonReader::getInt);
                } else if ("usage".equals(fieldName)) {
                    deserializedBenefitRecommendationProperties.usage = RecommendationUsageDetails.fromJson(reader);
                } else if ("armSkuName".equals(fieldName)) {
                    deserializedBenefitRecommendationProperties.armSkuName = reader.getString();
                } else if ("term".equals(fieldName)) {
                    deserializedBenefitRecommendationProperties.term = Term.fromString(reader.getString());
                } else if ("commitmentGranularity".equals(fieldName)) {
                    deserializedBenefitRecommendationProperties.commitmentGranularity
                        = Grain.fromString(reader.getString());
                } else if ("currencyCode".equals(fieldName)) {
                    deserializedBenefitRecommendationProperties.currencyCode = reader.getString();
                } else if ("costWithoutBenefit".equals(fieldName)) {
                    deserializedBenefitRecommendationProperties.costWithoutBenefit
                        = reader.getNullable(nonNullReader -> new BigDecimal(nonNullReader.getString()));
                } else if ("recommendationDetails".equals(fieldName)) {
                    deserializedBenefitRecommendationProperties.recommendationDetails
                        = AllSavingsBenefitDetails.fromJson(reader);
                } else if ("allRecommendationDetails".equals(fieldName)) {
                    deserializedBenefitRecommendationProperties.allRecommendationDetails
                        = AllSavingsList.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedBenefitRecommendationProperties;
        });
    }
}
