// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.costmanagement.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The benefit resource model definition.
 */
@Fluent
public class BenefitResource extends ProxyResource {
    /*
     * Reservation or SavingsPlan.
     */
    private BenefitKind kind;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of BenefitResource class.
     */
    public BenefitResource() {
    }

    /**
     * Get the kind property: Reservation or SavingsPlan.
     * 
     * @return the kind value.
     */
    public BenefitKind kind() {
        return this.kind;
    }

    /**
     * Set the kind property: Reservation or SavingsPlan.
     * 
     * @param kind the kind value to set.
     * @return the BenefitResource object itself.
     */
    public BenefitResource withKind(BenefitKind kind) {
        this.kind = kind;
        return this;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kind", this.kind == null ? null : this.kind.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of BenefitResource from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of BenefitResource if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the BenefitResource.
     */
    public static BenefitResource fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            BenefitResource deserializedBenefitResource = new BenefitResource();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedBenefitResource.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedBenefitResource.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedBenefitResource.type = reader.getString();
                } else if ("kind".equals(fieldName)) {
                    deserializedBenefitResource.kind = BenefitKind.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedBenefitResource;
        });
    }
}
