// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.costmanagement.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;

/**
 * The properties of a benefit utilization summary.
 */
@Fluent
public class BenefitUtilizationSummaryProperties implements JsonSerializable<BenefitUtilizationSummaryProperties> {
    /*
     * ARM SKU name. For example, 'Compute_Savings_Plan' for savings plan.
     */
    private String armSkuName;

    /*
     * The benefit ID is the identifier of the benefit.
     */
    private String benefitId;

    /*
     * The benefit order ID is the identifier for a benefit purchase.
     */
    private String benefitOrderId;

    /*
     * The benefit type. Supported values: 'SavingsPlan'.
     */
    private BenefitKind benefitType;

    /*
     * Date corresponding to the utilization summary record. If the grain of data is monthly, value for this field will
     * be first day of the month.
     */
    private OffsetDateTime usageDate;

    /**
     * Creates an instance of BenefitUtilizationSummaryProperties class.
     */
    public BenefitUtilizationSummaryProperties() {
    }

    /**
     * Get the armSkuName property: ARM SKU name. For example, 'Compute_Savings_Plan' for savings plan.
     * 
     * @return the armSkuName value.
     */
    public String armSkuName() {
        return this.armSkuName;
    }

    /**
     * Set the armSkuName property: ARM SKU name. For example, 'Compute_Savings_Plan' for savings plan.
     * 
     * @param armSkuName the armSkuName value to set.
     * @return the BenefitUtilizationSummaryProperties object itself.
     */
    BenefitUtilizationSummaryProperties withArmSkuName(String armSkuName) {
        this.armSkuName = armSkuName;
        return this;
    }

    /**
     * Get the benefitId property: The benefit ID is the identifier of the benefit.
     * 
     * @return the benefitId value.
     */
    public String benefitId() {
        return this.benefitId;
    }

    /**
     * Set the benefitId property: The benefit ID is the identifier of the benefit.
     * 
     * @param benefitId the benefitId value to set.
     * @return the BenefitUtilizationSummaryProperties object itself.
     */
    BenefitUtilizationSummaryProperties withBenefitId(String benefitId) {
        this.benefitId = benefitId;
        return this;
    }

    /**
     * Get the benefitOrderId property: The benefit order ID is the identifier for a benefit purchase.
     * 
     * @return the benefitOrderId value.
     */
    public String benefitOrderId() {
        return this.benefitOrderId;
    }

    /**
     * Set the benefitOrderId property: The benefit order ID is the identifier for a benefit purchase.
     * 
     * @param benefitOrderId the benefitOrderId value to set.
     * @return the BenefitUtilizationSummaryProperties object itself.
     */
    BenefitUtilizationSummaryProperties withBenefitOrderId(String benefitOrderId) {
        this.benefitOrderId = benefitOrderId;
        return this;
    }

    /**
     * Get the benefitType property: The benefit type. Supported values: 'SavingsPlan'.
     * 
     * @return the benefitType value.
     */
    public BenefitKind benefitType() {
        return this.benefitType;
    }

    /**
     * Set the benefitType property: The benefit type. Supported values: 'SavingsPlan'.
     * 
     * @param benefitType the benefitType value to set.
     * @return the BenefitUtilizationSummaryProperties object itself.
     */
    public BenefitUtilizationSummaryProperties withBenefitType(BenefitKind benefitType) {
        this.benefitType = benefitType;
        return this;
    }

    /**
     * Get the usageDate property: Date corresponding to the utilization summary record. If the grain of data is
     * monthly, value for this field will be first day of the month.
     * 
     * @return the usageDate value.
     */
    public OffsetDateTime usageDate() {
        return this.usageDate;
    }

    /**
     * Set the usageDate property: Date corresponding to the utilization summary record. If the grain of data is
     * monthly, value for this field will be first day of the month.
     * 
     * @param usageDate the usageDate value to set.
     * @return the BenefitUtilizationSummaryProperties object itself.
     */
    BenefitUtilizationSummaryProperties withUsageDate(OffsetDateTime usageDate) {
        this.usageDate = usageDate;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("benefitType", this.benefitType == null ? null : this.benefitType.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of BenefitUtilizationSummaryProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of BenefitUtilizationSummaryProperties if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the BenefitUtilizationSummaryProperties.
     */
    public static BenefitUtilizationSummaryProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            BenefitUtilizationSummaryProperties deserializedBenefitUtilizationSummaryProperties
                = new BenefitUtilizationSummaryProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("armSkuName".equals(fieldName)) {
                    deserializedBenefitUtilizationSummaryProperties.armSkuName = reader.getString();
                } else if ("benefitId".equals(fieldName)) {
                    deserializedBenefitUtilizationSummaryProperties.benefitId = reader.getString();
                } else if ("benefitOrderId".equals(fieldName)) {
                    deserializedBenefitUtilizationSummaryProperties.benefitOrderId = reader.getString();
                } else if ("benefitType".equals(fieldName)) {
                    deserializedBenefitUtilizationSummaryProperties.benefitType
                        = BenefitKind.fromString(reader.getString());
                } else if ("usageDate".equals(fieldName)) {
                    deserializedBenefitUtilizationSummaryProperties.usageDate = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedBenefitUtilizationSummaryProperties;
        });
    }
}
