// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.costmanagement.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The blob information generated by this operation.
 */
@Fluent
public final class BlobInfo implements JsonSerializable<BlobInfo> {
    /*
     * Link to the blob to download file.
     */
    private String blobLink;

    /*
     * Bytes in the blob.
     */
    private Long byteCount;

    /**
     * Creates an instance of BlobInfo class.
     */
    public BlobInfo() {
    }

    /**
     * Get the blobLink property: Link to the blob to download file.
     * 
     * @return the blobLink value.
     */
    public String blobLink() {
        return this.blobLink;
    }

    /**
     * Set the blobLink property: Link to the blob to download file.
     * 
     * @param blobLink the blobLink value to set.
     * @return the BlobInfo object itself.
     */
    public BlobInfo withBlobLink(String blobLink) {
        this.blobLink = blobLink;
        return this;
    }

    /**
     * Get the byteCount property: Bytes in the blob.
     * 
     * @return the byteCount value.
     */
    public Long byteCount() {
        return this.byteCount;
    }

    /**
     * Set the byteCount property: Bytes in the blob.
     * 
     * @param byteCount the byteCount value to set.
     * @return the BlobInfo object itself.
     */
    public BlobInfo withByteCount(Long byteCount) {
        this.byteCount = byteCount;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("blobLink", this.blobLink);
        jsonWriter.writeNumberField("byteCount", this.byteCount);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of BlobInfo from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of BlobInfo if the JsonReader was pointing to an instance of it, or null if it was pointing
     * to JSON null.
     * @throws IOException If an error occurs while reading the BlobInfo.
     */
    public static BlobInfo fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            BlobInfo deserializedBlobInfo = new BlobInfo();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("blobLink".equals(fieldName)) {
                    deserializedBlobInfo.blobLink = reader.getString();
                } else if ("byteCount".equals(fieldName)) {
                    deserializedBlobInfo.byteCount = reader.getNullable(JsonReader::getLong);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedBlobInfo;
        });
    }
}
