// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.costmanagement.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The start and end date for pulling data for the cost detailed report. API only allows data to be pulled for 1 month
 * or less and no older than 13 months.
 */
@Fluent
public final class CostDetailsTimePeriod implements JsonSerializable<CostDetailsTimePeriod> {
    /*
     * The start date to pull data from. example format 2020-03-15
     */
    private String start;

    /*
     * The end date to pull data to. example format 2020-03-15
     */
    private String end;

    /**
     * Creates an instance of CostDetailsTimePeriod class.
     */
    public CostDetailsTimePeriod() {
    }

    /**
     * Get the start property: The start date to pull data from. example format 2020-03-15.
     * 
     * @return the start value.
     */
    public String start() {
        return this.start;
    }

    /**
     * Set the start property: The start date to pull data from. example format 2020-03-15.
     * 
     * @param start the start value to set.
     * @return the CostDetailsTimePeriod object itself.
     */
    public CostDetailsTimePeriod withStart(String start) {
        this.start = start;
        return this;
    }

    /**
     * Get the end property: The end date to pull data to. example format 2020-03-15.
     * 
     * @return the end value.
     */
    public String end() {
        return this.end;
    }

    /**
     * Set the end property: The end date to pull data to. example format 2020-03-15.
     * 
     * @param end the end value to set.
     * @return the CostDetailsTimePeriod object itself.
     */
    public CostDetailsTimePeriod withEnd(String end) {
        this.end = end;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (start() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property start in model CostDetailsTimePeriod"));
        }
        if (end() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property end in model CostDetailsTimePeriod"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(CostDetailsTimePeriod.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("start", this.start);
        jsonWriter.writeStringField("end", this.end);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of CostDetailsTimePeriod from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of CostDetailsTimePeriod if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the CostDetailsTimePeriod.
     */
    public static CostDetailsTimePeriod fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            CostDetailsTimePeriod deserializedCostDetailsTimePeriod = new CostDetailsTimePeriod();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("start".equals(fieldName)) {
                    deserializedCostDetailsTimePeriod.start = reader.getString();
                } else if ("end".equals(fieldName)) {
                    deserializedCostDetailsTimePeriod.end = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedCostDetailsTimePeriod;
        });
    }
}
