// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.costmanagement.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.costmanagement.fluent.models.DimensionInner;
import java.io.IOException;
import java.util.List;

/**
 * Result of listing dimensions. It contains a list of available dimensions.
 */
@Immutable
public final class DimensionsListResult implements JsonSerializable<DimensionsListResult> {
    /*
     * The list of dimensions.
     */
    private List<DimensionInner> value;

    /**
     * Creates an instance of DimensionsListResult class.
     */
    public DimensionsListResult() {
    }

    /**
     * Get the value property: The list of dimensions.
     * 
     * @return the value value.
     */
    public List<DimensionInner> value() {
        return this.value;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DimensionsListResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DimensionsListResult if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the DimensionsListResult.
     */
    public static DimensionsListResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DimensionsListResult deserializedDimensionsListResult = new DimensionsListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<DimensionInner> value = reader.readArray(reader1 -> DimensionInner.fromJson(reader1));
                    deserializedDimensionsListResult.value = value;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDimensionsListResult;
        });
    }
}
