// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.costmanagement.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

/**
 * The start and end date for recurrence schedule.
 */
@Fluent
public final class ExportRecurrencePeriod implements JsonSerializable<ExportRecurrencePeriod> {
    /*
     * The start date of recurrence.
     */
    private OffsetDateTime from;

    /*
     * The end date of recurrence.
     */
    private OffsetDateTime to;

    /**
     * Creates an instance of ExportRecurrencePeriod class.
     */
    public ExportRecurrencePeriod() {
    }

    /**
     * Get the from property: The start date of recurrence.
     * 
     * @return the from value.
     */
    public OffsetDateTime from() {
        return this.from;
    }

    /**
     * Set the from property: The start date of recurrence.
     * 
     * @param from the from value to set.
     * @return the ExportRecurrencePeriod object itself.
     */
    public ExportRecurrencePeriod withFrom(OffsetDateTime from) {
        this.from = from;
        return this;
    }

    /**
     * Get the to property: The end date of recurrence.
     * 
     * @return the to value.
     */
    public OffsetDateTime to() {
        return this.to;
    }

    /**
     * Set the to property: The end date of recurrence.
     * 
     * @param to the to value to set.
     * @return the ExportRecurrencePeriod object itself.
     */
    public ExportRecurrencePeriod withTo(OffsetDateTime to) {
        this.to = to;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (from() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property from in model ExportRecurrencePeriod"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(ExportRecurrencePeriod.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("from",
            this.from == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.from));
        jsonWriter.writeStringField("to",
            this.to == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.to));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ExportRecurrencePeriod from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ExportRecurrencePeriod if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ExportRecurrencePeriod.
     */
    public static ExportRecurrencePeriod fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ExportRecurrencePeriod deserializedExportRecurrencePeriod = new ExportRecurrencePeriod();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("from".equals(fieldName)) {
                    deserializedExportRecurrencePeriod.from = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("to".equals(fieldName)) {
                    deserializedExportRecurrencePeriod.to = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedExportRecurrencePeriod;
        });
    }
}
