// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.costmanagement.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Map;

/**
 * The definition of data present in the forecast.
 */
@Fluent
public final class ForecastDataset implements JsonSerializable<ForecastDataset> {
    /*
     * The granularity of rows in the forecast.
     */
    private GranularityType granularity;

    /*
     * Has configuration information for the data in the export. The configuration will be ignored if aggregation and
     * grouping are provided.
     */
    private ForecastDatasetConfiguration configuration;

    /*
     * Dictionary of aggregation expression to use in the forecast. The key of each item in the dictionary is the alias
     * for the aggregated column. forecast can have up to 2 aggregation clauses.
     */
    private Map<String, ForecastAggregation> aggregation;

    /*
     * Has filter expression to use in the forecast.
     */
    private ForecastFilter filter;

    /**
     * Creates an instance of ForecastDataset class.
     */
    public ForecastDataset() {
    }

    /**
     * Get the granularity property: The granularity of rows in the forecast.
     * 
     * @return the granularity value.
     */
    public GranularityType granularity() {
        return this.granularity;
    }

    /**
     * Set the granularity property: The granularity of rows in the forecast.
     * 
     * @param granularity the granularity value to set.
     * @return the ForecastDataset object itself.
     */
    public ForecastDataset withGranularity(GranularityType granularity) {
        this.granularity = granularity;
        return this;
    }

    /**
     * Get the configuration property: Has configuration information for the data in the export. The configuration will
     * be ignored if aggregation and grouping are provided.
     * 
     * @return the configuration value.
     */
    public ForecastDatasetConfiguration configuration() {
        return this.configuration;
    }

    /**
     * Set the configuration property: Has configuration information for the data in the export. The configuration will
     * be ignored if aggregation and grouping are provided.
     * 
     * @param configuration the configuration value to set.
     * @return the ForecastDataset object itself.
     */
    public ForecastDataset withConfiguration(ForecastDatasetConfiguration configuration) {
        this.configuration = configuration;
        return this;
    }

    /**
     * Get the aggregation property: Dictionary of aggregation expression to use in the forecast. The key of each item
     * in the dictionary is the alias for the aggregated column. forecast can have up to 2 aggregation clauses.
     * 
     * @return the aggregation value.
     */
    public Map<String, ForecastAggregation> aggregation() {
        return this.aggregation;
    }

    /**
     * Set the aggregation property: Dictionary of aggregation expression to use in the forecast. The key of each item
     * in the dictionary is the alias for the aggregated column. forecast can have up to 2 aggregation clauses.
     * 
     * @param aggregation the aggregation value to set.
     * @return the ForecastDataset object itself.
     */
    public ForecastDataset withAggregation(Map<String, ForecastAggregation> aggregation) {
        this.aggregation = aggregation;
        return this;
    }

    /**
     * Get the filter property: Has filter expression to use in the forecast.
     * 
     * @return the filter value.
     */
    public ForecastFilter filter() {
        return this.filter;
    }

    /**
     * Set the filter property: Has filter expression to use in the forecast.
     * 
     * @param filter the filter value to set.
     * @return the ForecastDataset object itself.
     */
    public ForecastDataset withFilter(ForecastFilter filter) {
        this.filter = filter;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (configuration() != null) {
            configuration().validate();
        }
        if (aggregation() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property aggregation in model ForecastDataset"));
        } else {
            aggregation().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
        if (filter() != null) {
            filter().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(ForecastDataset.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeMapField("aggregation", this.aggregation, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("granularity", this.granularity == null ? null : this.granularity.toString());
        jsonWriter.writeJsonField("configuration", this.configuration);
        jsonWriter.writeJsonField("filter", this.filter);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ForecastDataset from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ForecastDataset if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ForecastDataset.
     */
    public static ForecastDataset fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ForecastDataset deserializedForecastDataset = new ForecastDataset();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("aggregation".equals(fieldName)) {
                    Map<String, ForecastAggregation> aggregation
                        = reader.readMap(reader1 -> ForecastAggregation.fromJson(reader1));
                    deserializedForecastDataset.aggregation = aggregation;
                } else if ("granularity".equals(fieldName)) {
                    deserializedForecastDataset.granularity = GranularityType.fromString(reader.getString());
                } else if ("configuration".equals(fieldName)) {
                    deserializedForecastDataset.configuration = ForecastDatasetConfiguration.fromJson(reader);
                } else if ("filter".equals(fieldName)) {
                    deserializedForecastDataset.filter = ForecastFilter.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedForecastDataset;
        });
    }
}
