// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.costmanagement.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * The filter expression to be used in the export.
 */
@Fluent
public final class ForecastFilter implements JsonSerializable<ForecastFilter> {
    /*
     * The logical "AND" expression. Must have at least 2 items.
     */
    private List<ForecastFilter> and;

    /*
     * The logical "OR" expression. Must have at least 2 items.
     */
    private List<ForecastFilter> or;

    /*
     * Has comparison expression for a dimension
     */
    private ForecastComparisonExpression dimensions;

    /*
     * Has comparison expression for a tag
     */
    private ForecastComparisonExpression tags;

    /**
     * Creates an instance of ForecastFilter class.
     */
    public ForecastFilter() {
    }

    /**
     * Get the and property: The logical "AND" expression. Must have at least 2 items.
     * 
     * @return the and value.
     */
    public List<ForecastFilter> and() {
        return this.and;
    }

    /**
     * Set the and property: The logical "AND" expression. Must have at least 2 items.
     * 
     * @param and the and value to set.
     * @return the ForecastFilter object itself.
     */
    public ForecastFilter withAnd(List<ForecastFilter> and) {
        this.and = and;
        return this;
    }

    /**
     * Get the or property: The logical "OR" expression. Must have at least 2 items.
     * 
     * @return the or value.
     */
    public List<ForecastFilter> or() {
        return this.or;
    }

    /**
     * Set the or property: The logical "OR" expression. Must have at least 2 items.
     * 
     * @param or the or value to set.
     * @return the ForecastFilter object itself.
     */
    public ForecastFilter withOr(List<ForecastFilter> or) {
        this.or = or;
        return this;
    }

    /**
     * Get the dimensions property: Has comparison expression for a dimension.
     * 
     * @return the dimensions value.
     */
    public ForecastComparisonExpression dimensions() {
        return this.dimensions;
    }

    /**
     * Set the dimensions property: Has comparison expression for a dimension.
     * 
     * @param dimensions the dimensions value to set.
     * @return the ForecastFilter object itself.
     */
    public ForecastFilter withDimensions(ForecastComparisonExpression dimensions) {
        this.dimensions = dimensions;
        return this;
    }

    /**
     * Get the tags property: Has comparison expression for a tag.
     * 
     * @return the tags value.
     */
    public ForecastComparisonExpression tags() {
        return this.tags;
    }

    /**
     * Set the tags property: Has comparison expression for a tag.
     * 
     * @param tags the tags value to set.
     * @return the ForecastFilter object itself.
     */
    public ForecastFilter withTags(ForecastComparisonExpression tags) {
        this.tags = tags;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (and() != null) {
            and().forEach(e -> e.validate());
        }
        if (or() != null) {
            or().forEach(e -> e.validate());
        }
        if (dimensions() != null) {
            dimensions().validate();
        }
        if (tags() != null) {
            tags().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("and", this.and, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("or", this.or, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeJsonField("dimensions", this.dimensions);
        jsonWriter.writeJsonField("tags", this.tags);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ForecastFilter from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ForecastFilter if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the ForecastFilter.
     */
    public static ForecastFilter fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ForecastFilter deserializedForecastFilter = new ForecastFilter();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("and".equals(fieldName)) {
                    List<ForecastFilter> and = reader.readArray(reader1 -> ForecastFilter.fromJson(reader1));
                    deserializedForecastFilter.and = and;
                } else if ("or".equals(fieldName)) {
                    List<ForecastFilter> or = reader.readArray(reader1 -> ForecastFilter.fromJson(reader1));
                    deserializedForecastFilter.or = or;
                } else if ("dimensions".equals(fieldName)) {
                    deserializedForecastFilter.dimensions = ForecastComparisonExpression.fromJson(reader);
                } else if ("tags".equals(fieldName)) {
                    deserializedForecastFilter.tags = ForecastComparisonExpression.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedForecastFilter;
        });
    }
}
