// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.costmanagement.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The definition of a cost detailed report.
 */
@Fluent
public final class GenerateCostDetailsReportRequestDefinition
    implements JsonSerializable<GenerateCostDetailsReportRequestDefinition> {
    /*
     * The type of the detailed report. By default ActualCost is provided
     */
    private CostDetailsMetricType metric;

    /*
     * The specific date range of cost details requested for the report. This parameter cannot be used alongside either
     * the invoiceId or billingPeriod parameters. If a timePeriod, invoiceId or billingPeriod parameter is not provided
     * in the request body the API will return the current month's cost. API only allows data to be pulled for 1 month
     * or less and no older than 13 months. If no timePeriod or billingPeriod or invoiceId is provided the API defaults
     * to the open month time period
     */
    private CostDetailsTimePeriod timePeriod;

    /*
     * This parameter can be used only by Enterprise Agreement customers. Use the YearMonth(e.g. 202008) format. This
     * parameter cannot be used alongside either the invoiceId or timePeriod parameters. If a timePeriod, invoiceId or
     * billingPeriod parameter is not provided in the request body the API will return the current month's cost.
     */
    private String billingPeriod;

    /*
     * This parameter can only be used by Microsoft Customer Agreement customers. Additionally, it can only be used at
     * the Billing Profile or Customer scope. This parameter cannot be used alongside either the billingPeriod or
     * timePeriod parameters. If a timePeriod, invoiceId or billingPeriod parameter is not provided in the request body
     * the API will return the current month's cost.
     */
    private String invoiceId;

    /**
     * Creates an instance of GenerateCostDetailsReportRequestDefinition class.
     */
    public GenerateCostDetailsReportRequestDefinition() {
    }

    /**
     * Get the metric property: The type of the detailed report. By default ActualCost is provided.
     * 
     * @return the metric value.
     */
    public CostDetailsMetricType metric() {
        return this.metric;
    }

    /**
     * Set the metric property: The type of the detailed report. By default ActualCost is provided.
     * 
     * @param metric the metric value to set.
     * @return the GenerateCostDetailsReportRequestDefinition object itself.
     */
    public GenerateCostDetailsReportRequestDefinition withMetric(CostDetailsMetricType metric) {
        this.metric = metric;
        return this;
    }

    /**
     * Get the timePeriod property: The specific date range of cost details requested for the report. This parameter
     * cannot be used alongside either the invoiceId or billingPeriod parameters. If a timePeriod, invoiceId or
     * billingPeriod parameter is not provided in the request body the API will return the current month's cost. API
     * only allows data to be pulled for 1 month or less and no older than 13 months. If no timePeriod or billingPeriod
     * or invoiceId is provided the API defaults to the open month time period.
     * 
     * @return the timePeriod value.
     */
    public CostDetailsTimePeriod timePeriod() {
        return this.timePeriod;
    }

    /**
     * Set the timePeriod property: The specific date range of cost details requested for the report. This parameter
     * cannot be used alongside either the invoiceId or billingPeriod parameters. If a timePeriod, invoiceId or
     * billingPeriod parameter is not provided in the request body the API will return the current month's cost. API
     * only allows data to be pulled for 1 month or less and no older than 13 months. If no timePeriod or billingPeriod
     * or invoiceId is provided the API defaults to the open month time period.
     * 
     * @param timePeriod the timePeriod value to set.
     * @return the GenerateCostDetailsReportRequestDefinition object itself.
     */
    public GenerateCostDetailsReportRequestDefinition withTimePeriod(CostDetailsTimePeriod timePeriod) {
        this.timePeriod = timePeriod;
        return this;
    }

    /**
     * Get the billingPeriod property: This parameter can be used only by Enterprise Agreement customers. Use the
     * YearMonth(e.g. 202008) format. This parameter cannot be used alongside either the invoiceId or timePeriod
     * parameters. If a timePeriod, invoiceId or billingPeriod parameter is not provided in the request body the API
     * will return the current month's cost.
     * 
     * @return the billingPeriod value.
     */
    public String billingPeriod() {
        return this.billingPeriod;
    }

    /**
     * Set the billingPeriod property: This parameter can be used only by Enterprise Agreement customers. Use the
     * YearMonth(e.g. 202008) format. This parameter cannot be used alongside either the invoiceId or timePeriod
     * parameters. If a timePeriod, invoiceId or billingPeriod parameter is not provided in the request body the API
     * will return the current month's cost.
     * 
     * @param billingPeriod the billingPeriod value to set.
     * @return the GenerateCostDetailsReportRequestDefinition object itself.
     */
    public GenerateCostDetailsReportRequestDefinition withBillingPeriod(String billingPeriod) {
        this.billingPeriod = billingPeriod;
        return this;
    }

    /**
     * Get the invoiceId property: This parameter can only be used by Microsoft Customer Agreement customers.
     * Additionally, it can only be used at the Billing Profile or Customer scope. This parameter cannot be used
     * alongside either the billingPeriod or timePeriod parameters. If a timePeriod, invoiceId or billingPeriod
     * parameter is not provided in the request body the API will return the current month's cost.
     * 
     * @return the invoiceId value.
     */
    public String invoiceId() {
        return this.invoiceId;
    }

    /**
     * Set the invoiceId property: This parameter can only be used by Microsoft Customer Agreement customers.
     * Additionally, it can only be used at the Billing Profile or Customer scope. This parameter cannot be used
     * alongside either the billingPeriod or timePeriod parameters. If a timePeriod, invoiceId or billingPeriod
     * parameter is not provided in the request body the API will return the current month's cost.
     * 
     * @param invoiceId the invoiceId value to set.
     * @return the GenerateCostDetailsReportRequestDefinition object itself.
     */
    public GenerateCostDetailsReportRequestDefinition withInvoiceId(String invoiceId) {
        this.invoiceId = invoiceId;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (timePeriod() != null) {
            timePeriod().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("metric", this.metric == null ? null : this.metric.toString());
        jsonWriter.writeJsonField("timePeriod", this.timePeriod);
        jsonWriter.writeStringField("billingPeriod", this.billingPeriod);
        jsonWriter.writeStringField("invoiceId", this.invoiceId);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of GenerateCostDetailsReportRequestDefinition from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of GenerateCostDetailsReportRequestDefinition if the JsonReader was pointing to an instance
     * of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the GenerateCostDetailsReportRequestDefinition.
     */
    public static GenerateCostDetailsReportRequestDefinition fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            GenerateCostDetailsReportRequestDefinition deserializedGenerateCostDetailsReportRequestDefinition
                = new GenerateCostDetailsReportRequestDefinition();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("metric".equals(fieldName)) {
                    deserializedGenerateCostDetailsReportRequestDefinition.metric
                        = CostDetailsMetricType.fromString(reader.getString());
                } else if ("timePeriod".equals(fieldName)) {
                    deserializedGenerateCostDetailsReportRequestDefinition.timePeriod
                        = CostDetailsTimePeriod.fromJson(reader);
                } else if ("billingPeriod".equals(fieldName)) {
                    deserializedGenerateCostDetailsReportRequestDefinition.billingPeriod = reader.getString();
                } else if ("invoiceId".equals(fieldName)) {
                    deserializedGenerateCostDetailsReportRequestDefinition.invoiceId = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedGenerateCostDetailsReportRequestDefinition;
        });
    }
}
