// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.costmanagement.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The definition of a cost detailed report.
 */
@Fluent
public final class GenerateDetailedCostReportDefinition
    implements JsonSerializable<GenerateDetailedCostReportDefinition> {
    /*
     * The type of the detailed report. By default ActualCost is provided
     */
    private GenerateDetailedCostReportMetricType metric;

    /*
     * Has time period for pulling data for the cost detailed report. Can only have one of either timePeriod or
     * invoiceId or billingPeriod parameters. If none provided current month cost is provided.
     */
    private GenerateDetailedCostReportTimePeriod timePeriod;

    /*
     * Billing period in YearMonth(e.g. 202008) format. Only for legacy enterprise customers can use this. Can only have
     * one of either timePeriod or invoiceId or billingPeriod parameters. If none provided current month cost is
     * provided.
     */
    private String billingPeriod;

    /*
     * Invoice ID for Pay-as-you-go and Microsoft Customer Agreement scopes. Can only have one of either timePeriod or
     * invoiceId or billingPeriod parameters. If none provided current month cost is provided.
     */
    private String invoiceId;

    /*
     * Customer ID for Microsoft Customer Agreement scopes (Invoice Id is also required for this).
     */
    private String customerId;

    /**
     * Creates an instance of GenerateDetailedCostReportDefinition class.
     */
    public GenerateDetailedCostReportDefinition() {
    }

    /**
     * Get the metric property: The type of the detailed report. By default ActualCost is provided.
     * 
     * @return the metric value.
     */
    public GenerateDetailedCostReportMetricType metric() {
        return this.metric;
    }

    /**
     * Set the metric property: The type of the detailed report. By default ActualCost is provided.
     * 
     * @param metric the metric value to set.
     * @return the GenerateDetailedCostReportDefinition object itself.
     */
    public GenerateDetailedCostReportDefinition withMetric(GenerateDetailedCostReportMetricType metric) {
        this.metric = metric;
        return this;
    }

    /**
     * Get the timePeriod property: Has time period for pulling data for the cost detailed report. Can only have one of
     * either timePeriod or invoiceId or billingPeriod parameters. If none provided current month cost is provided.
     * 
     * @return the timePeriod value.
     */
    public GenerateDetailedCostReportTimePeriod timePeriod() {
        return this.timePeriod;
    }

    /**
     * Set the timePeriod property: Has time period for pulling data for the cost detailed report. Can only have one of
     * either timePeriod or invoiceId or billingPeriod parameters. If none provided current month cost is provided.
     * 
     * @param timePeriod the timePeriod value to set.
     * @return the GenerateDetailedCostReportDefinition object itself.
     */
    public GenerateDetailedCostReportDefinition withTimePeriod(GenerateDetailedCostReportTimePeriod timePeriod) {
        this.timePeriod = timePeriod;
        return this;
    }

    /**
     * Get the billingPeriod property: Billing period in YearMonth(e.g. 202008) format. Only for legacy enterprise
     * customers can use this. Can only have one of either timePeriod or invoiceId or billingPeriod parameters. If none
     * provided current month cost is provided.
     * 
     * @return the billingPeriod value.
     */
    public String billingPeriod() {
        return this.billingPeriod;
    }

    /**
     * Set the billingPeriod property: Billing period in YearMonth(e.g. 202008) format. Only for legacy enterprise
     * customers can use this. Can only have one of either timePeriod or invoiceId or billingPeriod parameters. If none
     * provided current month cost is provided.
     * 
     * @param billingPeriod the billingPeriod value to set.
     * @return the GenerateDetailedCostReportDefinition object itself.
     */
    public GenerateDetailedCostReportDefinition withBillingPeriod(String billingPeriod) {
        this.billingPeriod = billingPeriod;
        return this;
    }

    /**
     * Get the invoiceId property: Invoice ID for Pay-as-you-go and Microsoft Customer Agreement scopes. Can only have
     * one of either timePeriod or invoiceId or billingPeriod parameters. If none provided current month cost is
     * provided.
     * 
     * @return the invoiceId value.
     */
    public String invoiceId() {
        return this.invoiceId;
    }

    /**
     * Set the invoiceId property: Invoice ID for Pay-as-you-go and Microsoft Customer Agreement scopes. Can only have
     * one of either timePeriod or invoiceId or billingPeriod parameters. If none provided current month cost is
     * provided.
     * 
     * @param invoiceId the invoiceId value to set.
     * @return the GenerateDetailedCostReportDefinition object itself.
     */
    public GenerateDetailedCostReportDefinition withInvoiceId(String invoiceId) {
        this.invoiceId = invoiceId;
        return this;
    }

    /**
     * Get the customerId property: Customer ID for Microsoft Customer Agreement scopes (Invoice Id is also required for
     * this).
     * 
     * @return the customerId value.
     */
    public String customerId() {
        return this.customerId;
    }

    /**
     * Set the customerId property: Customer ID for Microsoft Customer Agreement scopes (Invoice Id is also required for
     * this).
     * 
     * @param customerId the customerId value to set.
     * @return the GenerateDetailedCostReportDefinition object itself.
     */
    public GenerateDetailedCostReportDefinition withCustomerId(String customerId) {
        this.customerId = customerId;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (timePeriod() != null) {
            timePeriod().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("metric", this.metric == null ? null : this.metric.toString());
        jsonWriter.writeJsonField("timePeriod", this.timePeriod);
        jsonWriter.writeStringField("billingPeriod", this.billingPeriod);
        jsonWriter.writeStringField("invoiceId", this.invoiceId);
        jsonWriter.writeStringField("customerId", this.customerId);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of GenerateDetailedCostReportDefinition from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of GenerateDetailedCostReportDefinition if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the GenerateDetailedCostReportDefinition.
     */
    public static GenerateDetailedCostReportDefinition fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            GenerateDetailedCostReportDefinition deserializedGenerateDetailedCostReportDefinition
                = new GenerateDetailedCostReportDefinition();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("metric".equals(fieldName)) {
                    deserializedGenerateDetailedCostReportDefinition.metric
                        = GenerateDetailedCostReportMetricType.fromString(reader.getString());
                } else if ("timePeriod".equals(fieldName)) {
                    deserializedGenerateDetailedCostReportDefinition.timePeriod
                        = GenerateDetailedCostReportTimePeriod.fromJson(reader);
                } else if ("billingPeriod".equals(fieldName)) {
                    deserializedGenerateDetailedCostReportDefinition.billingPeriod = reader.getString();
                } else if ("invoiceId".equals(fieldName)) {
                    deserializedGenerateDetailedCostReportDefinition.invoiceId = reader.getString();
                } else if ("customerId".equals(fieldName)) {
                    deserializedGenerateDetailedCostReportDefinition.customerId = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedGenerateDetailedCostReportDefinition;
        });
    }
}
