// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.costmanagement.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Each pivot must contain a 'type' and 'name'.
 */
@Fluent
public final class PivotProperties implements JsonSerializable<PivotProperties> {
    /*
     * Data type to show in view.
     */
    private PivotType type;

    /*
     * Data field to show in view.
     */
    private String name;

    /**
     * Creates an instance of PivotProperties class.
     */
    public PivotProperties() {
    }

    /**
     * Get the type property: Data type to show in view.
     * 
     * @return the type value.
     */
    public PivotType type() {
        return this.type;
    }

    /**
     * Set the type property: Data type to show in view.
     * 
     * @param type the type value to set.
     * @return the PivotProperties object itself.
     */
    public PivotProperties withType(PivotType type) {
        this.type = type;
        return this;
    }

    /**
     * Get the name property: Data field to show in view.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: Data field to show in view.
     * 
     * @param name the name value to set.
     * @return the PivotProperties object itself.
     */
    public PivotProperties withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeStringField("name", this.name);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of PivotProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of PivotProperties if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the PivotProperties.
     */
    public static PivotProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            PivotProperties deserializedPivotProperties = new PivotProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("type".equals(fieldName)) {
                    deserializedPivotProperties.type = PivotType.fromString(reader.getString());
                } else if ("name".equals(fieldName)) {
                    deserializedPivotProperties.name = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedPivotProperties;
        });
    }
}
