// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.costmanagement.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * The configuration of dataset in the query.
 */
@Fluent
public final class QueryDatasetConfiguration implements JsonSerializable<QueryDatasetConfiguration> {
    /*
     * Array of column names to be included in the query. Any valid query column name is allowed. If not provided, then
     * query includes all columns.
     */
    private List<String> columns;

    /**
     * Creates an instance of QueryDatasetConfiguration class.
     */
    public QueryDatasetConfiguration() {
    }

    /**
     * Get the columns property: Array of column names to be included in the query. Any valid query column name is
     * allowed. If not provided, then query includes all columns.
     * 
     * @return the columns value.
     */
    public List<String> columns() {
        return this.columns;
    }

    /**
     * Set the columns property: Array of column names to be included in the query. Any valid query column name is
     * allowed. If not provided, then query includes all columns.
     * 
     * @param columns the columns value to set.
     * @return the QueryDatasetConfiguration object itself.
     */
    public QueryDatasetConfiguration withColumns(List<String> columns) {
        this.columns = columns;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("columns", this.columns, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of QueryDatasetConfiguration from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of QueryDatasetConfiguration if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the QueryDatasetConfiguration.
     */
    public static QueryDatasetConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            QueryDatasetConfiguration deserializedQueryDatasetConfiguration = new QueryDatasetConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("columns".equals(fieldName)) {
                    List<String> columns = reader.readArray(reader1 -> reader1.getString());
                    deserializedQueryDatasetConfiguration.columns = columns;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedQueryDatasetConfiguration;
        });
    }
}
