// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.costmanagement.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;
import java.util.Map;

/**
 * The definition of data present in the report.
 */
@Fluent
public final class ReportConfigDataset implements JsonSerializable<ReportConfigDataset> {
    /*
     * The granularity of rows in the report.
     */
    private ReportGranularityType granularity;

    /*
     * Has configuration information for the data in the report. The configuration will be ignored if aggregation and
     * grouping are provided.
     */
    private ReportConfigDatasetConfiguration configuration;

    /*
     * Dictionary of aggregation expression to use in the report. The key of each item in the dictionary is the alias
     * for the aggregated column. Report can have up to 2 aggregation clauses.
     */
    private Map<String, ReportConfigAggregation> aggregation;

    /*
     * Array of group by expression to use in the report. Report can have up to 2 group by clauses.
     */
    private List<ReportConfigGrouping> grouping;

    /*
     * Array of order by expression to use in the report.
     */
    private List<ReportConfigSorting> sorting;

    /*
     * Has filter expression to use in the report.
     */
    private ReportConfigFilter filter;

    /**
     * Creates an instance of ReportConfigDataset class.
     */
    public ReportConfigDataset() {
    }

    /**
     * Get the granularity property: The granularity of rows in the report.
     * 
     * @return the granularity value.
     */
    public ReportGranularityType granularity() {
        return this.granularity;
    }

    /**
     * Set the granularity property: The granularity of rows in the report.
     * 
     * @param granularity the granularity value to set.
     * @return the ReportConfigDataset object itself.
     */
    public ReportConfigDataset withGranularity(ReportGranularityType granularity) {
        this.granularity = granularity;
        return this;
    }

    /**
     * Get the configuration property: Has configuration information for the data in the report. The configuration will
     * be ignored if aggregation and grouping are provided.
     * 
     * @return the configuration value.
     */
    public ReportConfigDatasetConfiguration configuration() {
        return this.configuration;
    }

    /**
     * Set the configuration property: Has configuration information for the data in the report. The configuration will
     * be ignored if aggregation and grouping are provided.
     * 
     * @param configuration the configuration value to set.
     * @return the ReportConfigDataset object itself.
     */
    public ReportConfigDataset withConfiguration(ReportConfigDatasetConfiguration configuration) {
        this.configuration = configuration;
        return this;
    }

    /**
     * Get the aggregation property: Dictionary of aggregation expression to use in the report. The key of each item in
     * the dictionary is the alias for the aggregated column. Report can have up to 2 aggregation clauses.
     * 
     * @return the aggregation value.
     */
    public Map<String, ReportConfigAggregation> aggregation() {
        return this.aggregation;
    }

    /**
     * Set the aggregation property: Dictionary of aggregation expression to use in the report. The key of each item in
     * the dictionary is the alias for the aggregated column. Report can have up to 2 aggregation clauses.
     * 
     * @param aggregation the aggregation value to set.
     * @return the ReportConfigDataset object itself.
     */
    public ReportConfigDataset withAggregation(Map<String, ReportConfigAggregation> aggregation) {
        this.aggregation = aggregation;
        return this;
    }

    /**
     * Get the grouping property: Array of group by expression to use in the report. Report can have up to 2 group by
     * clauses.
     * 
     * @return the grouping value.
     */
    public List<ReportConfigGrouping> grouping() {
        return this.grouping;
    }

    /**
     * Set the grouping property: Array of group by expression to use in the report. Report can have up to 2 group by
     * clauses.
     * 
     * @param grouping the grouping value to set.
     * @return the ReportConfigDataset object itself.
     */
    public ReportConfigDataset withGrouping(List<ReportConfigGrouping> grouping) {
        this.grouping = grouping;
        return this;
    }

    /**
     * Get the sorting property: Array of order by expression to use in the report.
     * 
     * @return the sorting value.
     */
    public List<ReportConfigSorting> sorting() {
        return this.sorting;
    }

    /**
     * Set the sorting property: Array of order by expression to use in the report.
     * 
     * @param sorting the sorting value to set.
     * @return the ReportConfigDataset object itself.
     */
    public ReportConfigDataset withSorting(List<ReportConfigSorting> sorting) {
        this.sorting = sorting;
        return this;
    }

    /**
     * Get the filter property: Has filter expression to use in the report.
     * 
     * @return the filter value.
     */
    public ReportConfigFilter filter() {
        return this.filter;
    }

    /**
     * Set the filter property: Has filter expression to use in the report.
     * 
     * @param filter the filter value to set.
     * @return the ReportConfigDataset object itself.
     */
    public ReportConfigDataset withFilter(ReportConfigFilter filter) {
        this.filter = filter;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (configuration() != null) {
            configuration().validate();
        }
        if (aggregation() != null) {
            aggregation().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
        if (grouping() != null) {
            grouping().forEach(e -> e.validate());
        }
        if (sorting() != null) {
            sorting().forEach(e -> e.validate());
        }
        if (filter() != null) {
            filter().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("granularity", this.granularity == null ? null : this.granularity.toString());
        jsonWriter.writeJsonField("configuration", this.configuration);
        jsonWriter.writeMapField("aggregation", this.aggregation, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("grouping", this.grouping, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("sorting", this.sorting, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeJsonField("filter", this.filter);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ReportConfigDataset from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ReportConfigDataset if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the ReportConfigDataset.
     */
    public static ReportConfigDataset fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ReportConfigDataset deserializedReportConfigDataset = new ReportConfigDataset();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("granularity".equals(fieldName)) {
                    deserializedReportConfigDataset.granularity = ReportGranularityType.fromString(reader.getString());
                } else if ("configuration".equals(fieldName)) {
                    deserializedReportConfigDataset.configuration = ReportConfigDatasetConfiguration.fromJson(reader);
                } else if ("aggregation".equals(fieldName)) {
                    Map<String, ReportConfigAggregation> aggregation
                        = reader.readMap(reader1 -> ReportConfigAggregation.fromJson(reader1));
                    deserializedReportConfigDataset.aggregation = aggregation;
                } else if ("grouping".equals(fieldName)) {
                    List<ReportConfigGrouping> grouping
                        = reader.readArray(reader1 -> ReportConfigGrouping.fromJson(reader1));
                    deserializedReportConfigDataset.grouping = grouping;
                } else if ("sorting".equals(fieldName)) {
                    List<ReportConfigSorting> sorting
                        = reader.readArray(reader1 -> ReportConfigSorting.fromJson(reader1));
                    deserializedReportConfigDataset.sorting = sorting;
                } else if ("filter".equals(fieldName)) {
                    deserializedReportConfigDataset.filter = ReportConfigFilter.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedReportConfigDataset;
        });
    }
}
