// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.costmanagement.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The order by expression to be used in the report.
 */
@Fluent
public final class ReportConfigSorting implements JsonSerializable<ReportConfigSorting> {
    /*
     * Direction of sort.
     */
    private ReportConfigSortingType direction;

    /*
     * The name of the column to sort.
     */
    private String name;

    /**
     * Creates an instance of ReportConfigSorting class.
     */
    public ReportConfigSorting() {
    }

    /**
     * Get the direction property: Direction of sort.
     * 
     * @return the direction value.
     */
    public ReportConfigSortingType direction() {
        return this.direction;
    }

    /**
     * Set the direction property: Direction of sort.
     * 
     * @param direction the direction value to set.
     * @return the ReportConfigSorting object itself.
     */
    public ReportConfigSorting withDirection(ReportConfigSortingType direction) {
        this.direction = direction;
        return this;
    }

    /**
     * Get the name property: The name of the column to sort.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: The name of the column to sort.
     * 
     * @param name the name value to set.
     * @return the ReportConfigSorting object itself.
     */
    public ReportConfigSorting withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (name() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property name in model ReportConfigSorting"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(ReportConfigSorting.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("direction", this.direction == null ? null : this.direction.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ReportConfigSorting from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ReportConfigSorting if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ReportConfigSorting.
     */
    public static ReportConfigSorting fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ReportConfigSorting deserializedReportConfigSorting = new ReportConfigSorting();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedReportConfigSorting.name = reader.getString();
                } else if ("direction".equals(fieldName)) {
                    deserializedReportConfigSorting.direction = ReportConfigSortingType.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedReportConfigSorting;
        });
    }
}
