// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.costmanagement.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Frequency of the schedule.
 */
public final class ScheduleFrequency extends ExpandableStringEnum<ScheduleFrequency> {
    /**
     * Static value Daily for ScheduleFrequency.
     */
    public static final ScheduleFrequency DAILY = fromString("Daily");

    /**
     * Static value Weekly for ScheduleFrequency.
     */
    public static final ScheduleFrequency WEEKLY = fromString("Weekly");

    /**
     * Static value Monthly for ScheduleFrequency.
     */
    public static final ScheduleFrequency MONTHLY = fromString("Monthly");

    /**
     * Creates a new instance of ScheduleFrequency value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public ScheduleFrequency() {
    }

    /**
     * Creates or finds a ScheduleFrequency from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding ScheduleFrequency.
     */
    public static ScheduleFrequency fromString(String name) {
        return fromString(name, ScheduleFrequency.class);
    }

    /**
     * Gets known ScheduleFrequency values.
     * 
     * @return known ScheduleFrequency values.
     */
    public static Collection<ScheduleFrequency> values() {
        return values(ScheduleFrequency.class);
    }
}
