// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.costmanagement.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.costmanagement.fluent.models.ScheduledActionInner;
import java.io.IOException;
import java.util.List;

/**
 * Scheduled actions list result. It contains a list of scheduled actions.
 */
@Immutable
public final class ScheduledActionListResult implements JsonSerializable<ScheduledActionListResult> {
    /*
     * The list of scheduled actions.
     */
    private List<ScheduledActionInner> value;

    /*
     * The link (url) to the next page of results.
     */
    private String nextLink;

    /**
     * Creates an instance of ScheduledActionListResult class.
     */
    public ScheduledActionListResult() {
    }

    /**
     * Get the value property: The list of scheduled actions.
     * 
     * @return the value value.
     */
    public List<ScheduledActionInner> value() {
        return this.value;
    }

    /**
     * Get the nextLink property: The link (url) to the next page of results.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ScheduledActionListResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ScheduledActionListResult if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ScheduledActionListResult.
     */
    public static ScheduledActionListResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ScheduledActionListResult deserializedScheduledActionListResult = new ScheduledActionListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<ScheduledActionInner> value
                        = reader.readArray(reader1 -> ScheduledActionInner.fromJson(reader1));
                    deserializedScheduledActionListResult.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedScheduledActionListResult.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedScheduledActionListResult;
        });
    }
}
