// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.costmanagement.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.math.BigDecimal;

/**
 * The properties of the benefit recommendations when scope is 'Single'.
 */
@Fluent
public final class SingleScopeBenefitRecommendationProperties extends BenefitRecommendationProperties {
    /*
     * Benefit scope. For example, Single or Shared.
     */
    private Scope scope = Scope.SINGLE;

    /*
     * The subscription ID that this single scope recommendation is for. Applicable only if recommendation is for
     * 'Single' scope.
     */
    private String subscriptionId;

    /*
     * The resource group that this single scope recommendation is for. Applicable only if recommendation is for
     * 'Single' scope and 'ResourceGroup' request scope.
     */
    private String resourceGroup;

    /**
     * Creates an instance of SingleScopeBenefitRecommendationProperties class.
     */
    public SingleScopeBenefitRecommendationProperties() {
    }

    /**
     * Get the scope property: Benefit scope. For example, Single or Shared.
     * 
     * @return the scope value.
     */
    @Override
    public Scope scope() {
        return this.scope;
    }

    /**
     * Get the subscriptionId property: The subscription ID that this single scope recommendation is for. Applicable
     * only if recommendation is for 'Single' scope.
     * 
     * @return the subscriptionId value.
     */
    public String subscriptionId() {
        return this.subscriptionId;
    }

    /**
     * Get the resourceGroup property: The resource group that this single scope recommendation is for. Applicable only
     * if recommendation is for 'Single' scope and 'ResourceGroup' request scope.
     * 
     * @return the resourceGroup value.
     */
    public String resourceGroup() {
        return this.resourceGroup;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public SingleScopeBenefitRecommendationProperties withLookBackPeriod(LookBackPeriod lookBackPeriod) {
        super.withLookBackPeriod(lookBackPeriod);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public SingleScopeBenefitRecommendationProperties withUsage(RecommendationUsageDetails usage) {
        super.withUsage(usage);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public SingleScopeBenefitRecommendationProperties withTerm(Term term) {
        super.withTerm(term);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public SingleScopeBenefitRecommendationProperties withCommitmentGranularity(Grain commitmentGranularity) {
        super.withCommitmentGranularity(commitmentGranularity);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public SingleScopeBenefitRecommendationProperties
        withRecommendationDetails(AllSavingsBenefitDetails recommendationDetails) {
        super.withRecommendationDetails(recommendationDetails);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        if (usage() != null) {
            usage().validate();
        }
        if (recommendationDetails() != null) {
            recommendationDetails().validate();
        }
        if (allRecommendationDetails() != null) {
            allRecommendationDetails().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("lookBackPeriod", lookBackPeriod() == null ? null : lookBackPeriod().toString());
        jsonWriter.writeJsonField("usage", usage());
        jsonWriter.writeStringField("term", term() == null ? null : term().toString());
        jsonWriter.writeStringField("commitmentGranularity",
            commitmentGranularity() == null ? null : commitmentGranularity().toString());
        jsonWriter.writeJsonField("recommendationDetails", recommendationDetails());
        jsonWriter.writeStringField("scope", this.scope == null ? null : this.scope.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SingleScopeBenefitRecommendationProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SingleScopeBenefitRecommendationProperties if the JsonReader was pointing to an instance
     * of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the SingleScopeBenefitRecommendationProperties.
     */
    public static SingleScopeBenefitRecommendationProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SingleScopeBenefitRecommendationProperties deserializedSingleScopeBenefitRecommendationProperties
                = new SingleScopeBenefitRecommendationProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("firstConsumptionDate".equals(fieldName)) {
                    deserializedSingleScopeBenefitRecommendationProperties.withFirstConsumptionDate(reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString())));
                } else if ("lastConsumptionDate".equals(fieldName)) {
                    deserializedSingleScopeBenefitRecommendationProperties.withLastConsumptionDate(reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString())));
                } else if ("lookBackPeriod".equals(fieldName)) {
                    deserializedSingleScopeBenefitRecommendationProperties
                        .withLookBackPeriod(LookBackPeriod.fromString(reader.getString()));
                } else if ("totalHours".equals(fieldName)) {
                    deserializedSingleScopeBenefitRecommendationProperties
                        .withTotalHours(reader.getNullable(JsonReader::getInt));
                } else if ("usage".equals(fieldName)) {
                    deserializedSingleScopeBenefitRecommendationProperties
                        .withUsage(RecommendationUsageDetails.fromJson(reader));
                } else if ("armSkuName".equals(fieldName)) {
                    deserializedSingleScopeBenefitRecommendationProperties.withArmSkuName(reader.getString());
                } else if ("term".equals(fieldName)) {
                    deserializedSingleScopeBenefitRecommendationProperties
                        .withTerm(Term.fromString(reader.getString()));
                } else if ("commitmentGranularity".equals(fieldName)) {
                    deserializedSingleScopeBenefitRecommendationProperties
                        .withCommitmentGranularity(Grain.fromString(reader.getString()));
                } else if ("currencyCode".equals(fieldName)) {
                    deserializedSingleScopeBenefitRecommendationProperties.withCurrencyCode(reader.getString());
                } else if ("costWithoutBenefit".equals(fieldName)) {
                    deserializedSingleScopeBenefitRecommendationProperties.withCostWithoutBenefit(
                        reader.getNullable(nonNullReader -> new BigDecimal(nonNullReader.getString())));
                } else if ("recommendationDetails".equals(fieldName)) {
                    deserializedSingleScopeBenefitRecommendationProperties
                        .withRecommendationDetails(AllSavingsBenefitDetails.fromJson(reader));
                } else if ("allRecommendationDetails".equals(fieldName)) {
                    deserializedSingleScopeBenefitRecommendationProperties
                        .withAllRecommendationDetails(AllSavingsList.fromJson(reader));
                } else if ("scope".equals(fieldName)) {
                    deserializedSingleScopeBenefitRecommendationProperties.scope = Scope.fromString(reader.getString());
                } else if ("subscriptionId".equals(fieldName)) {
                    deserializedSingleScopeBenefitRecommendationProperties.subscriptionId = reader.getString();
                } else if ("resourceGroup".equals(fieldName)) {
                    deserializedSingleScopeBenefitRecommendationProperties.resourceGroup = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSingleScopeBenefitRecommendationProperties;
        });
    }
}
