// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.costmanagement.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The status of the long running operation.
 */
@Fluent
public final class Status implements JsonSerializable<Status> {
    /*
     * The status of the long running operation.
     */
    private ReportOperationStatusType status;

    /**
     * Creates an instance of Status class.
     */
    public Status() {
    }

    /**
     * Get the status property: The status of the long running operation.
     * 
     * @return the status value.
     */
    public ReportOperationStatusType status() {
        return this.status;
    }

    /**
     * Set the status property: The status of the long running operation.
     * 
     * @param status the status value to set.
     * @return the Status object itself.
     */
    public Status withStatus(ReportOperationStatusType status) {
        this.status = status;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("status", this.status == null ? null : this.status.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of Status from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of Status if the JsonReader was pointing to an instance of it, or null if it was pointing to
     * JSON null.
     * @throws IOException If an error occurs while reading the Status.
     */
    public static Status fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            Status deserializedStatus = new Status();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("status".equals(fieldName)) {
                    deserializedStatus.status = ReportOperationStatusType.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedStatus;
        });
    }
}
