// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.costmanagement.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * The time frame for pulling data for the query. If custom, then a specific time period must be provided.
 */
public final class TimeframeType extends ExpandableStringEnum<TimeframeType> {
    /**
     * Static value MonthToDate for TimeframeType.
     */
    public static final TimeframeType MONTH_TO_DATE = fromString("MonthToDate");

    /**
     * Static value BillingMonthToDate for TimeframeType.
     */
    public static final TimeframeType BILLING_MONTH_TO_DATE = fromString("BillingMonthToDate");

    /**
     * Static value TheLastMonth for TimeframeType.
     */
    public static final TimeframeType THE_LAST_MONTH = fromString("TheLastMonth");

    /**
     * Static value TheLastBillingMonth for TimeframeType.
     */
    public static final TimeframeType THE_LAST_BILLING_MONTH = fromString("TheLastBillingMonth");

    /**
     * Static value WeekToDate for TimeframeType.
     */
    public static final TimeframeType WEEK_TO_DATE = fromString("WeekToDate");

    /**
     * Static value Custom for TimeframeType.
     */
    public static final TimeframeType CUSTOM = fromString("Custom");

    /**
     * Creates a new instance of TimeframeType value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public TimeframeType() {
    }

    /**
     * Creates or finds a TimeframeType from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding TimeframeType.
     */
    public static TimeframeType fromString(String name) {
        return fromString(name, TimeframeType.class);
    }

    /**
     * Gets known TimeframeType values.
     * 
     * @return known TimeframeType values.
     */
    public static Collection<TimeframeType> values() {
        return values(TimeframeType.class);
    }
}
