// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.costmanagement.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.costmanagement.fluent.models.ViewInner;
import java.io.IOException;
import java.util.List;

/**
 * Result of listing views. It contains a list of available views.
 */
@Immutable
public final class ViewListResult implements JsonSerializable<ViewListResult> {
    /*
     * The list of views.
     */
    private List<ViewInner> value;

    /*
     * The link (url) to the next page of results.
     */
    private String nextLink;

    /**
     * Creates an instance of ViewListResult class.
     */
    public ViewListResult() {
    }

    /**
     * Get the value property: The list of views.
     * 
     * @return the value value.
     */
    public List<ViewInner> value() {
        return this.value;
    }

    /**
     * Get the nextLink property: The link (url) to the next page of results.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ViewListResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ViewListResult if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the ViewListResult.
     */
    public static ViewListResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ViewListResult deserializedViewListResult = new ViewListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<ViewInner> value = reader.readArray(reader1 -> ViewInner.fromJson(reader1));
                    deserializedViewListResult.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedViewListResult.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedViewListResult;
        });
    }
}
