/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.costmanagement;

import com.azure.core.credential.TokenCredential;
import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.HttpPipelinePosition;
import com.azure.core.http.policy.AddDatePolicy;
import com.azure.core.http.policy.AddHeadersFromContextPolicy;
import com.azure.core.http.policy.BearerTokenAuthenticationPolicy;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.core.http.policy.HttpLoggingPolicy;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.HttpPolicyProviders;
import com.azure.core.http.policy.RequestIdPolicy;
import com.azure.core.http.policy.RetryOptions;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.management.profile.AzureProfile;
import com.azure.core.util.Configuration;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.costmanagement.fluent.CostManagementClient;
import com.azure.resourcemanager.costmanagement.implementation.AlertsImpl;
import com.azure.resourcemanager.costmanagement.implementation.BenefitRecommendationsImpl;
import com.azure.resourcemanager.costmanagement.implementation.BenefitUtilizationSummariesImpl;
import com.azure.resourcemanager.costmanagement.implementation.CostManagementClientBuilder;
import com.azure.resourcemanager.costmanagement.implementation.DimensionsImpl;
import com.azure.resourcemanager.costmanagement.implementation.ExportsImpl;
import com.azure.resourcemanager.costmanagement.implementation.ForecastsImpl;
import com.azure.resourcemanager.costmanagement.implementation.GenerateCostDetailsReportsImpl;
import com.azure.resourcemanager.costmanagement.implementation.GenerateDetailedCostReportOperationResultsImpl;
import com.azure.resourcemanager.costmanagement.implementation.GenerateDetailedCostReportOperationStatusImpl;
import com.azure.resourcemanager.costmanagement.implementation.GenerateDetailedCostReportsImpl;
import com.azure.resourcemanager.costmanagement.implementation.GenerateReservationDetailsReportsImpl;
import com.azure.resourcemanager.costmanagement.implementation.OperationsImpl;
import com.azure.resourcemanager.costmanagement.implementation.PriceSheetsImpl;
import com.azure.resourcemanager.costmanagement.implementation.QueriesImpl;
import com.azure.resourcemanager.costmanagement.implementation.ScheduledActionsImpl;
import com.azure.resourcemanager.costmanagement.implementation.ViewsImpl;
import com.azure.resourcemanager.costmanagement.models.Alerts;
import com.azure.resourcemanager.costmanagement.models.BenefitRecommendations;
import com.azure.resourcemanager.costmanagement.models.BenefitUtilizationSummaries;
import com.azure.resourcemanager.costmanagement.models.Dimensions;
import com.azure.resourcemanager.costmanagement.models.Exports;
import com.azure.resourcemanager.costmanagement.models.Forecasts;
import com.azure.resourcemanager.costmanagement.models.GenerateCostDetailsReports;
import com.azure.resourcemanager.costmanagement.models.GenerateDetailedCostReportOperationResults;
import com.azure.resourcemanager.costmanagement.models.GenerateDetailedCostReportOperationStatus;
import com.azure.resourcemanager.costmanagement.models.GenerateDetailedCostReports;
import com.azure.resourcemanager.costmanagement.models.GenerateReservationDetailsReports;
import com.azure.resourcemanager.costmanagement.models.Operations;
import com.azure.resourcemanager.costmanagement.models.PriceSheets;
import com.azure.resourcemanager.costmanagement.models.Queries;
import com.azure.resourcemanager.costmanagement.models.ScheduledActions;
import com.azure.resourcemanager.costmanagement.models.Views;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public final class CostManagementManager {
    private Operations operations;
    private Views views;
    private Alerts alerts;
    private Forecasts forecasts;
    private Dimensions dimensions;
    private Queries queries;
    private GenerateReservationDetailsReports generateReservationDetailsReports;
    private Exports exports;
    private GenerateCostDetailsReports generateCostDetailsReports;
    private GenerateDetailedCostReports generateDetailedCostReports;
    private GenerateDetailedCostReportOperationResults generateDetailedCostReportOperationResults;
    private GenerateDetailedCostReportOperationStatus generateDetailedCostReportOperationStatus;
    private PriceSheets priceSheets;
    private ScheduledActions scheduledActions;
    private BenefitRecommendations benefitRecommendations;
    private BenefitUtilizationSummaries benefitUtilizationSummaries;
    private final CostManagementClient clientObject;

    private CostManagementManager(HttpPipeline httpPipeline, AzureProfile profile, Duration defaultPollInterval) {
        Objects.requireNonNull(httpPipeline, "'httpPipeline' cannot be null.");
        Objects.requireNonNull(profile, "'profile' cannot be null.");
        this.clientObject = new CostManagementClientBuilder().pipeline(httpPipeline).endpoint(profile.getEnvironment().getResourceManagerEndpoint()).defaultPollInterval(defaultPollInterval).buildClient();
    }

    public static CostManagementManager authenticate(TokenCredential credential, AzureProfile profile) {
        Objects.requireNonNull(credential, "'credential' cannot be null.");
        Objects.requireNonNull(profile, "'profile' cannot be null.");
        return CostManagementManager.configure().authenticate(credential, profile);
    }

    public static CostManagementManager authenticate(HttpPipeline httpPipeline, AzureProfile profile) {
        Objects.requireNonNull(httpPipeline, "'httpPipeline' cannot be null.");
        Objects.requireNonNull(profile, "'profile' cannot be null.");
        return new CostManagementManager(httpPipeline, profile, null);
    }

    public static Configurable configure() {
        return new Configurable();
    }

    public Operations operations() {
        if (this.operations == null) {
            this.operations = new OperationsImpl(this.clientObject.getOperations(), this);
        }
        return this.operations;
    }

    public Views views() {
        if (this.views == null) {
            this.views = new ViewsImpl(this.clientObject.getViews(), this);
        }
        return this.views;
    }

    public Alerts alerts() {
        if (this.alerts == null) {
            this.alerts = new AlertsImpl(this.clientObject.getAlerts(), this);
        }
        return this.alerts;
    }

    public Forecasts forecasts() {
        if (this.forecasts == null) {
            this.forecasts = new ForecastsImpl(this.clientObject.getForecasts(), this);
        }
        return this.forecasts;
    }

    public Dimensions dimensions() {
        if (this.dimensions == null) {
            this.dimensions = new DimensionsImpl(this.clientObject.getDimensions(), this);
        }
        return this.dimensions;
    }

    public Queries queries() {
        if (this.queries == null) {
            this.queries = new QueriesImpl(this.clientObject.getQueries(), this);
        }
        return this.queries;
    }

    public GenerateReservationDetailsReports generateReservationDetailsReports() {
        if (this.generateReservationDetailsReports == null) {
            this.generateReservationDetailsReports = new GenerateReservationDetailsReportsImpl(this.clientObject.getGenerateReservationDetailsReports(), this);
        }
        return this.generateReservationDetailsReports;
    }

    public Exports exports() {
        if (this.exports == null) {
            this.exports = new ExportsImpl(this.clientObject.getExports(), this);
        }
        return this.exports;
    }

    public GenerateCostDetailsReports generateCostDetailsReports() {
        if (this.generateCostDetailsReports == null) {
            this.generateCostDetailsReports = new GenerateCostDetailsReportsImpl(this.clientObject.getGenerateCostDetailsReports(), this);
        }
        return this.generateCostDetailsReports;
    }

    public GenerateDetailedCostReports generateDetailedCostReports() {
        if (this.generateDetailedCostReports == null) {
            this.generateDetailedCostReports = new GenerateDetailedCostReportsImpl(this.clientObject.getGenerateDetailedCostReports(), this);
        }
        return this.generateDetailedCostReports;
    }

    public GenerateDetailedCostReportOperationResults generateDetailedCostReportOperationResults() {
        if (this.generateDetailedCostReportOperationResults == null) {
            this.generateDetailedCostReportOperationResults = new GenerateDetailedCostReportOperationResultsImpl(this.clientObject.getGenerateDetailedCostReportOperationResults(), this);
        }
        return this.generateDetailedCostReportOperationResults;
    }

    public GenerateDetailedCostReportOperationStatus generateDetailedCostReportOperationStatus() {
        if (this.generateDetailedCostReportOperationStatus == null) {
            this.generateDetailedCostReportOperationStatus = new GenerateDetailedCostReportOperationStatusImpl(this.clientObject.getGenerateDetailedCostReportOperationStatus(), this);
        }
        return this.generateDetailedCostReportOperationStatus;
    }

    public PriceSheets priceSheets() {
        if (this.priceSheets == null) {
            this.priceSheets = new PriceSheetsImpl(this.clientObject.getPriceSheets(), this);
        }
        return this.priceSheets;
    }

    public ScheduledActions scheduledActions() {
        if (this.scheduledActions == null) {
            this.scheduledActions = new ScheduledActionsImpl(this.clientObject.getScheduledActions(), this);
        }
        return this.scheduledActions;
    }

    public BenefitRecommendations benefitRecommendations() {
        if (this.benefitRecommendations == null) {
            this.benefitRecommendations = new BenefitRecommendationsImpl(this.clientObject.getBenefitRecommendations(), this);
        }
        return this.benefitRecommendations;
    }

    public BenefitUtilizationSummaries benefitUtilizationSummaries() {
        if (this.benefitUtilizationSummaries == null) {
            this.benefitUtilizationSummaries = new BenefitUtilizationSummariesImpl(this.clientObject.getBenefitUtilizationSummaries(), this);
        }
        return this.benefitUtilizationSummaries;
    }

    public CostManagementClient serviceClient() {
        return this.clientObject;
    }

    public static final class Configurable {
        private static final ClientLogger LOGGER = new ClientLogger(Configurable.class);
        private HttpClient httpClient;
        private HttpLogOptions httpLogOptions;
        private final List<HttpPipelinePolicy> policies = new ArrayList<HttpPipelinePolicy>();
        private final List<String> scopes = new ArrayList<String>();
        private RetryPolicy retryPolicy;
        private RetryOptions retryOptions;
        private Duration defaultPollInterval;

        private Configurable() {
        }

        public Configurable withHttpClient(HttpClient httpClient) {
            this.httpClient = Objects.requireNonNull(httpClient, "'httpClient' cannot be null.");
            return this;
        }

        public Configurable withLogOptions(HttpLogOptions httpLogOptions) {
            this.httpLogOptions = Objects.requireNonNull(httpLogOptions, "'httpLogOptions' cannot be null.");
            return this;
        }

        public Configurable withPolicy(HttpPipelinePolicy policy) {
            this.policies.add(Objects.requireNonNull(policy, "'policy' cannot be null."));
            return this;
        }

        public Configurable withScope(String scope) {
            this.scopes.add(Objects.requireNonNull(scope, "'scope' cannot be null."));
            return this;
        }

        public Configurable withRetryPolicy(RetryPolicy retryPolicy) {
            this.retryPolicy = Objects.requireNonNull(retryPolicy, "'retryPolicy' cannot be null.");
            return this;
        }

        public Configurable withRetryOptions(RetryOptions retryOptions) {
            this.retryOptions = Objects.requireNonNull(retryOptions, "'retryOptions' cannot be null.");
            return this;
        }

        public Configurable withDefaultPollInterval(Duration defaultPollInterval) {
            this.defaultPollInterval = Objects.requireNonNull(defaultPollInterval, "'defaultPollInterval' cannot be null.");
            if (this.defaultPollInterval.isNegative()) {
                throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("'defaultPollInterval' cannot be negative"));
            }
            return this;
        }

        public CostManagementManager authenticate(TokenCredential credential, AzureProfile profile) {
            Objects.requireNonNull(credential, "'credential' cannot be null.");
            Objects.requireNonNull(profile, "'profile' cannot be null.");
            StringBuilder userAgentBuilder = new StringBuilder();
            userAgentBuilder.append("azsdk-java").append("-").append("com.azure.resourcemanager.costmanagement").append("/").append("1.0.0");
            if (!((Boolean)Configuration.getGlobalConfiguration().get("AZURE_TELEMETRY_DISABLED", (Object)false)).booleanValue()) {
                userAgentBuilder.append(" (").append(Configuration.getGlobalConfiguration().get("java.version")).append("; ").append(Configuration.getGlobalConfiguration().get("os.name")).append("; ").append(Configuration.getGlobalConfiguration().get("os.version")).append("; auto-generated)");
            } else {
                userAgentBuilder.append(" (auto-generated)");
            }
            if (this.scopes.isEmpty()) {
                this.scopes.add(profile.getEnvironment().getManagementEndpoint() + "/.default");
            }
            if (this.retryPolicy == null) {
                this.retryPolicy = this.retryOptions != null ? new RetryPolicy(this.retryOptions) : new RetryPolicy("Retry-After", ChronoUnit.SECONDS);
            }
            ArrayList<Object> policies = new ArrayList<Object>();
            policies.add(new UserAgentPolicy(userAgentBuilder.toString()));
            policies.add(new AddHeadersFromContextPolicy());
            policies.add(new RequestIdPolicy());
            policies.addAll(this.policies.stream().filter(p -> p.getPipelinePosition() == HttpPipelinePosition.PER_CALL).collect(Collectors.toList()));
            HttpPolicyProviders.addBeforeRetryPolicies(policies);
            policies.add(this.retryPolicy);
            policies.add(new AddDatePolicy());
            policies.add(new BearerTokenAuthenticationPolicy(credential, this.scopes.toArray(new String[0])));
            policies.addAll(this.policies.stream().filter(p -> p.getPipelinePosition() == HttpPipelinePosition.PER_RETRY).collect(Collectors.toList()));
            HttpPolicyProviders.addAfterRetryPolicies(policies);
            policies.add(new HttpLoggingPolicy(this.httpLogOptions));
            HttpPipeline httpPipeline = new HttpPipelineBuilder().httpClient(this.httpClient).policies(policies.toArray(new HttpPipelinePolicy[0])).build();
            return new CostManagementManager(httpPipeline, profile, this.defaultPollInterval);
        }
    }
}

