/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.costmanagement.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.costmanagement.fluent.models.AlertProperties;
import com.azure.resourcemanager.costmanagement.models.AlertPropertiesDefinition;
import com.azure.resourcemanager.costmanagement.models.AlertPropertiesDetails;
import com.azure.resourcemanager.costmanagement.models.AlertSource;
import com.azure.resourcemanager.costmanagement.models.AlertStatus;
import com.azure.resourcemanager.costmanagement.models.CostManagementProxyResource;
import java.io.IOException;

public final class AlertInner
extends CostManagementProxyResource {
    private AlertProperties innerProperties;
    private String type;
    private String name;
    private String id;

    private AlertProperties innerProperties() {
        return this.innerProperties;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public AlertInner withEtag(String etag) {
        super.withEtag(etag);
        return this;
    }

    public AlertPropertiesDefinition definition() {
        return this.innerProperties() == null ? null : this.innerProperties().definition();
    }

    public AlertInner withDefinition(AlertPropertiesDefinition definition) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AlertProperties();
        }
        this.innerProperties().withDefinition(definition);
        return this;
    }

    public String description() {
        return this.innerProperties() == null ? null : this.innerProperties().description();
    }

    public AlertInner withDescription(String description) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AlertProperties();
        }
        this.innerProperties().withDescription(description);
        return this;
    }

    public AlertSource source() {
        return this.innerProperties() == null ? null : this.innerProperties().source();
    }

    public AlertInner withSource(AlertSource source) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AlertProperties();
        }
        this.innerProperties().withSource(source);
        return this;
    }

    public AlertPropertiesDetails details() {
        return this.innerProperties() == null ? null : this.innerProperties().details();
    }

    public AlertInner withDetails(AlertPropertiesDetails details) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AlertProperties();
        }
        this.innerProperties().withDetails(details);
        return this;
    }

    public String costEntityId() {
        return this.innerProperties() == null ? null : this.innerProperties().costEntityId();
    }

    public AlertInner withCostEntityId(String costEntityId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AlertProperties();
        }
        this.innerProperties().withCostEntityId(costEntityId);
        return this;
    }

    public AlertStatus status() {
        return this.innerProperties() == null ? null : this.innerProperties().status();
    }

    public AlertInner withStatus(AlertStatus status) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AlertProperties();
        }
        this.innerProperties().withStatus(status);
        return this;
    }

    public String creationTime() {
        return this.innerProperties() == null ? null : this.innerProperties().creationTime();
    }

    public AlertInner withCreationTime(String creationTime) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AlertProperties();
        }
        this.innerProperties().withCreationTime(creationTime);
        return this;
    }

    public String closeTime() {
        return this.innerProperties() == null ? null : this.innerProperties().closeTime();
    }

    public AlertInner withCloseTime(String closeTime) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AlertProperties();
        }
        this.innerProperties().withCloseTime(closeTime);
        return this;
    }

    public String modificationTime() {
        return this.innerProperties() == null ? null : this.innerProperties().modificationTime();
    }

    public AlertInner withModificationTime(String modificationTime) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AlertProperties();
        }
        this.innerProperties().withModificationTime(modificationTime);
        return this;
    }

    public String statusModificationUsername() {
        return this.innerProperties() == null ? null : this.innerProperties().statusModificationUsername();
    }

    public AlertInner withStatusModificationUsername(String statusModificationUsername) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AlertProperties();
        }
        this.innerProperties().withStatusModificationUsername(statusModificationUsername);
        return this;
    }

    public String statusModificationTime() {
        return this.innerProperties() == null ? null : this.innerProperties().statusModificationTime();
    }

    public AlertInner withStatusModificationTime(String statusModificationTime) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AlertProperties();
        }
        this.innerProperties().withStatusModificationTime(statusModificationTime);
        return this;
    }

    @Override
    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("eTag", this.etag());
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static AlertInner fromJson(JsonReader jsonReader) throws IOException {
        return (AlertInner)((Object)jsonReader.readObject(reader -> {
            AlertInner deserializedAlertInner = new AlertInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedAlertInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedAlertInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedAlertInner.type = reader.getString();
                    continue;
                }
                if ("eTag".equals(fieldName)) {
                    deserializedAlertInner.withEtag(reader.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedAlertInner.innerProperties = AlertProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAlertInner;
        }));
    }
}

