/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.costmanagement.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.costmanagement.models.AlertPropertiesDefinition;
import com.azure.resourcemanager.costmanagement.models.AlertPropertiesDetails;
import com.azure.resourcemanager.costmanagement.models.AlertSource;
import com.azure.resourcemanager.costmanagement.models.AlertStatus;
import java.io.IOException;

public final class AlertProperties
implements JsonSerializable<AlertProperties> {
    private AlertPropertiesDefinition definition;
    private String description;
    private AlertSource source;
    private AlertPropertiesDetails details;
    private String costEntityId;
    private AlertStatus status;
    private String creationTime;
    private String closeTime;
    private String modificationTime;
    private String statusModificationUsername;
    private String statusModificationTime;

    public AlertPropertiesDefinition definition() {
        return this.definition;
    }

    public AlertProperties withDefinition(AlertPropertiesDefinition definition) {
        this.definition = definition;
        return this;
    }

    public String description() {
        return this.description;
    }

    public AlertProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    public AlertSource source() {
        return this.source;
    }

    public AlertProperties withSource(AlertSource source) {
        this.source = source;
        return this;
    }

    public AlertPropertiesDetails details() {
        return this.details;
    }

    public AlertProperties withDetails(AlertPropertiesDetails details) {
        this.details = details;
        return this;
    }

    public String costEntityId() {
        return this.costEntityId;
    }

    public AlertProperties withCostEntityId(String costEntityId) {
        this.costEntityId = costEntityId;
        return this;
    }

    public AlertStatus status() {
        return this.status;
    }

    public AlertProperties withStatus(AlertStatus status) {
        this.status = status;
        return this;
    }

    public String creationTime() {
        return this.creationTime;
    }

    public AlertProperties withCreationTime(String creationTime) {
        this.creationTime = creationTime;
        return this;
    }

    public String closeTime() {
        return this.closeTime;
    }

    public AlertProperties withCloseTime(String closeTime) {
        this.closeTime = closeTime;
        return this;
    }

    public String modificationTime() {
        return this.modificationTime;
    }

    public AlertProperties withModificationTime(String modificationTime) {
        this.modificationTime = modificationTime;
        return this;
    }

    public String statusModificationUsername() {
        return this.statusModificationUsername;
    }

    public AlertProperties withStatusModificationUsername(String statusModificationUsername) {
        this.statusModificationUsername = statusModificationUsername;
        return this;
    }

    public String statusModificationTime() {
        return this.statusModificationTime;
    }

    public AlertProperties withStatusModificationTime(String statusModificationTime) {
        this.statusModificationTime = statusModificationTime;
        return this;
    }

    public void validate() {
        if (this.definition() != null) {
            this.definition().validate();
        }
        if (this.details() != null) {
            this.details().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("definition", (JsonSerializable)this.definition);
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeStringField("source", this.source == null ? null : this.source.toString());
        jsonWriter.writeJsonField("details", (JsonSerializable)this.details);
        jsonWriter.writeStringField("costEntityId", this.costEntityId);
        jsonWriter.writeStringField("status", this.status == null ? null : this.status.toString());
        jsonWriter.writeStringField("creationTime", this.creationTime);
        jsonWriter.writeStringField("closeTime", this.closeTime);
        jsonWriter.writeStringField("modificationTime", this.modificationTime);
        jsonWriter.writeStringField("statusModificationUserName", this.statusModificationUsername);
        jsonWriter.writeStringField("statusModificationTime", this.statusModificationTime);
        return jsonWriter.writeEndObject();
    }

    public static AlertProperties fromJson(JsonReader jsonReader) throws IOException {
        return (AlertProperties)jsonReader.readObject(reader -> {
            AlertProperties deserializedAlertProperties = new AlertProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("definition".equals(fieldName)) {
                    deserializedAlertProperties.definition = AlertPropertiesDefinition.fromJson(reader);
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedAlertProperties.description = reader.getString();
                    continue;
                }
                if ("source".equals(fieldName)) {
                    deserializedAlertProperties.source = AlertSource.fromString(reader.getString());
                    continue;
                }
                if ("details".equals(fieldName)) {
                    deserializedAlertProperties.details = AlertPropertiesDetails.fromJson(reader);
                    continue;
                }
                if ("costEntityId".equals(fieldName)) {
                    deserializedAlertProperties.costEntityId = reader.getString();
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedAlertProperties.status = AlertStatus.fromString(reader.getString());
                    continue;
                }
                if ("creationTime".equals(fieldName)) {
                    deserializedAlertProperties.creationTime = reader.getString();
                    continue;
                }
                if ("closeTime".equals(fieldName)) {
                    deserializedAlertProperties.closeTime = reader.getString();
                    continue;
                }
                if ("modificationTime".equals(fieldName)) {
                    deserializedAlertProperties.modificationTime = reader.getString();
                    continue;
                }
                if ("statusModificationUserName".equals(fieldName)) {
                    deserializedAlertProperties.statusModificationUsername = reader.getString();
                    continue;
                }
                if ("statusModificationTime".equals(fieldName)) {
                    deserializedAlertProperties.statusModificationTime = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAlertProperties;
        });
    }
}

