/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.costmanagement.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.costmanagement.fluent.models.ExportExecutionListResultInner;
import com.azure.resourcemanager.costmanagement.models.ExportDefinition;
import com.azure.resourcemanager.costmanagement.models.ExportDeliveryInfo;
import com.azure.resourcemanager.costmanagement.models.FormatType;
import java.io.IOException;
import java.time.OffsetDateTime;

public class CommonExportPropertiesInner
implements JsonSerializable<CommonExportPropertiesInner> {
    private FormatType format;
    private ExportDeliveryInfo deliveryInfo;
    private ExportDefinition definition;
    private ExportExecutionListResultInner runHistory;
    private Boolean partitionData;
    private OffsetDateTime nextRunTimeEstimate;
    private static final ClientLogger LOGGER = new ClientLogger(CommonExportPropertiesInner.class);

    public FormatType format() {
        return this.format;
    }

    public CommonExportPropertiesInner withFormat(FormatType format) {
        this.format = format;
        return this;
    }

    public ExportDeliveryInfo deliveryInfo() {
        return this.deliveryInfo;
    }

    public CommonExportPropertiesInner withDeliveryInfo(ExportDeliveryInfo deliveryInfo) {
        this.deliveryInfo = deliveryInfo;
        return this;
    }

    public ExportDefinition definition() {
        return this.definition;
    }

    public CommonExportPropertiesInner withDefinition(ExportDefinition definition) {
        this.definition = definition;
        return this;
    }

    public ExportExecutionListResultInner runHistory() {
        return this.runHistory;
    }

    public CommonExportPropertiesInner withRunHistory(ExportExecutionListResultInner runHistory) {
        this.runHistory = runHistory;
        return this;
    }

    public Boolean partitionData() {
        return this.partitionData;
    }

    public CommonExportPropertiesInner withPartitionData(Boolean partitionData) {
        this.partitionData = partitionData;
        return this;
    }

    public OffsetDateTime nextRunTimeEstimate() {
        return this.nextRunTimeEstimate;
    }

    CommonExportPropertiesInner withNextRunTimeEstimate(OffsetDateTime nextRunTimeEstimate) {
        this.nextRunTimeEstimate = nextRunTimeEstimate;
        return this;
    }

    public void validate() {
        if (this.deliveryInfo() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property deliveryInfo in model CommonExportPropertiesInner"));
        }
        this.deliveryInfo().validate();
        if (this.definition() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property definition in model CommonExportPropertiesInner"));
        }
        this.definition().validate();
        if (this.runHistory() != null) {
            this.runHistory().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("deliveryInfo", (JsonSerializable)this.deliveryInfo);
        jsonWriter.writeJsonField("definition", (JsonSerializable)this.definition);
        jsonWriter.writeStringField("format", this.format == null ? null : this.format.toString());
        jsonWriter.writeJsonField("runHistory", (JsonSerializable)this.runHistory);
        jsonWriter.writeBooleanField("partitionData", this.partitionData);
        return jsonWriter.writeEndObject();
    }

    public static CommonExportPropertiesInner fromJson(JsonReader jsonReader) throws IOException {
        return (CommonExportPropertiesInner)jsonReader.readObject(reader -> {
            CommonExportPropertiesInner deserializedCommonExportPropertiesInner = new CommonExportPropertiesInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("deliveryInfo".equals(fieldName)) {
                    deserializedCommonExportPropertiesInner.deliveryInfo = ExportDeliveryInfo.fromJson(reader);
                    continue;
                }
                if ("definition".equals(fieldName)) {
                    deserializedCommonExportPropertiesInner.definition = ExportDefinition.fromJson(reader);
                    continue;
                }
                if ("format".equals(fieldName)) {
                    deserializedCommonExportPropertiesInner.format = FormatType.fromString(reader.getString());
                    continue;
                }
                if ("runHistory".equals(fieldName)) {
                    deserializedCommonExportPropertiesInner.runHistory = ExportExecutionListResultInner.fromJson(reader);
                    continue;
                }
                if ("partitionData".equals(fieldName)) {
                    deserializedCommonExportPropertiesInner.partitionData = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("nextRunTimeEstimate".equals(fieldName)) {
                    deserializedCommonExportPropertiesInner.nextRunTimeEstimate = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCommonExportPropertiesInner;
        });
    }
}

