/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.costmanagement.fluent.models;

import com.azure.core.management.exception.ManagementError;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.costmanagement.fluent.models.ReportManifest;
import com.azure.resourcemanager.costmanagement.models.BlobInfo;
import com.azure.resourcemanager.costmanagement.models.CostDetailsDataFormat;
import com.azure.resourcemanager.costmanagement.models.CostDetailsStatusType;
import com.azure.resourcemanager.costmanagement.models.GenerateCostDetailsReportRequestDefinition;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;

public final class CostDetailsOperationResultsInner
implements JsonSerializable<CostDetailsOperationResultsInner> {
    private String id;
    private String name;
    private String type;
    private CostDetailsStatusType status;
    private ReportManifest innerManifest;
    private OffsetDateTime validTill;
    private ManagementError error;

    public String id() {
        return this.id;
    }

    public CostDetailsOperationResultsInner withId(String id) {
        this.id = id;
        return this;
    }

    public String name() {
        return this.name;
    }

    public CostDetailsOperationResultsInner withName(String name) {
        this.name = name;
        return this;
    }

    public String type() {
        return this.type;
    }

    public CostDetailsOperationResultsInner withType(String type) {
        this.type = type;
        return this;
    }

    public CostDetailsStatusType status() {
        return this.status;
    }

    public CostDetailsOperationResultsInner withStatus(CostDetailsStatusType status) {
        this.status = status;
        return this;
    }

    private ReportManifest innerManifest() {
        return this.innerManifest;
    }

    public OffsetDateTime validTill() {
        return this.validTill;
    }

    public CostDetailsOperationResultsInner withValidTill(OffsetDateTime validTill) {
        this.validTill = validTill;
        return this;
    }

    public ManagementError error() {
        return this.error;
    }

    public CostDetailsOperationResultsInner withError(ManagementError error) {
        this.error = error;
        return this;
    }

    public String manifestVersion() {
        return this.innerManifest() == null ? null : this.innerManifest().manifestVersion();
    }

    public CostDetailsOperationResultsInner withManifestVersion(String manifestVersion) {
        if (this.innerManifest() == null) {
            this.innerManifest = new ReportManifest();
        }
        this.innerManifest().withManifestVersion(manifestVersion);
        return this;
    }

    public CostDetailsDataFormat dataFormat() {
        return this.innerManifest() == null ? null : this.innerManifest().dataFormat();
    }

    public CostDetailsOperationResultsInner withDataFormat(CostDetailsDataFormat dataFormat) {
        if (this.innerManifest() == null) {
            this.innerManifest = new ReportManifest();
        }
        this.innerManifest().withDataFormat(dataFormat);
        return this;
    }

    public Long byteCount() {
        return this.innerManifest() == null ? null : this.innerManifest().byteCount();
    }

    public CostDetailsOperationResultsInner withByteCount(Long byteCount) {
        if (this.innerManifest() == null) {
            this.innerManifest = new ReportManifest();
        }
        this.innerManifest().withByteCount(byteCount);
        return this;
    }

    public Integer blobCount() {
        return this.innerManifest() == null ? null : this.innerManifest().blobCount();
    }

    public CostDetailsOperationResultsInner withBlobCount(Integer blobCount) {
        if (this.innerManifest() == null) {
            this.innerManifest = new ReportManifest();
        }
        this.innerManifest().withBlobCount(blobCount);
        return this;
    }

    public Boolean compressData() {
        return this.innerManifest() == null ? null : this.innerManifest().compressData();
    }

    public CostDetailsOperationResultsInner withCompressData(Boolean compressData) {
        if (this.innerManifest() == null) {
            this.innerManifest = new ReportManifest();
        }
        this.innerManifest().withCompressData(compressData);
        return this;
    }

    public List<BlobInfo> blobs() {
        return this.innerManifest() == null ? null : this.innerManifest().blobs();
    }

    public CostDetailsOperationResultsInner withBlobs(List<BlobInfo> blobs) {
        if (this.innerManifest() == null) {
            this.innerManifest = new ReportManifest();
        }
        this.innerManifest().withBlobs(blobs);
        return this;
    }

    public String requestScope() {
        return this.innerManifest() == null ? null : this.innerManifest().requestScope();
    }

    public CostDetailsOperationResultsInner withRequestScope(String requestScope) {
        if (this.innerManifest() == null) {
            this.innerManifest = new ReportManifest();
        }
        this.innerManifest().withRequestScope(requestScope);
        return this;
    }

    public GenerateCostDetailsReportRequestDefinition requestBody() {
        return this.innerManifest() == null ? null : this.innerManifest().requestBody();
    }

    public CostDetailsOperationResultsInner withRequestBody(GenerateCostDetailsReportRequestDefinition requestBody) {
        if (this.innerManifest() == null) {
            this.innerManifest = new ReportManifest();
        }
        this.innerManifest().withRequestBody(requestBody);
        return this;
    }

    public void validate() {
        if (this.innerManifest() != null) {
            this.innerManifest().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeStringField("status", this.status == null ? null : this.status.toString());
        jsonWriter.writeJsonField("manifest", (JsonSerializable)this.innerManifest);
        jsonWriter.writeStringField("validTill", this.validTill == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.validTill));
        jsonWriter.writeJsonField("error", (JsonSerializable)this.error);
        return jsonWriter.writeEndObject();
    }

    public static CostDetailsOperationResultsInner fromJson(JsonReader jsonReader) throws IOException {
        return (CostDetailsOperationResultsInner)jsonReader.readObject(reader -> {
            CostDetailsOperationResultsInner deserializedCostDetailsOperationResultsInner = new CostDetailsOperationResultsInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedCostDetailsOperationResultsInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedCostDetailsOperationResultsInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedCostDetailsOperationResultsInner.type = reader.getString();
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedCostDetailsOperationResultsInner.status = CostDetailsStatusType.fromString(reader.getString());
                    continue;
                }
                if ("manifest".equals(fieldName)) {
                    deserializedCostDetailsOperationResultsInner.innerManifest = ReportManifest.fromJson(reader);
                    continue;
                }
                if ("validTill".equals(fieldName)) {
                    deserializedCostDetailsOperationResultsInner.validTill = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("error".equals(fieldName)) {
                    deserializedCostDetailsOperationResultsInner.error = ManagementError.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCostDetailsOperationResultsInner;
        });
    }
}

