/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.costmanagement.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.costmanagement.models.ActionType;
import com.azure.resourcemanager.costmanagement.models.Operation;
import com.azure.resourcemanager.costmanagement.models.OperationDisplay;
import com.azure.resourcemanager.costmanagement.models.Origin;
import java.io.IOException;

public final class CostManagementOperationInner
extends Operation {
    private String id;
    private ActionType actionType;
    private Origin origin;
    private Boolean isDataAction;
    private String name;

    public String id() {
        return this.id;
    }

    @Override
    public ActionType actionType() {
        return this.actionType;
    }

    @Override
    public Origin origin() {
        return this.origin;
    }

    @Override
    public Boolean isDataAction() {
        return this.isDataAction;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public CostManagementOperationInner withDisplay(OperationDisplay display) {
        super.withDisplay(display);
        return this;
    }

    @Override
    public void validate() {
        if (this.display() != null) {
            this.display().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("display", (JsonSerializable)this.display());
        return jsonWriter.writeEndObject();
    }

    public static CostManagementOperationInner fromJson(JsonReader jsonReader) throws IOException {
        return (CostManagementOperationInner)jsonReader.readObject(reader -> {
            CostManagementOperationInner deserializedCostManagementOperationInner = new CostManagementOperationInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedCostManagementOperationInner.name = reader.getString();
                    continue;
                }
                if ("isDataAction".equals(fieldName)) {
                    deserializedCostManagementOperationInner.isDataAction = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("display".equals(fieldName)) {
                    deserializedCostManagementOperationInner.withDisplay(OperationDisplay.fromJson(reader));
                    continue;
                }
                if ("origin".equals(fieldName)) {
                    deserializedCostManagementOperationInner.origin = Origin.fromString(reader.getString());
                    continue;
                }
                if ("actionType".equals(fieldName)) {
                    deserializedCostManagementOperationInner.actionType = ActionType.fromString(reader.getString());
                    continue;
                }
                if ("id".equals(fieldName)) {
                    deserializedCostManagementOperationInner.id = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCostManagementOperationInner;
        });
    }
}

