/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.costmanagement.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.costmanagement.fluent.models.DimensionProperties;
import com.azure.resourcemanager.costmanagement.models.CostManagementResource;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;

public final class DimensionInner
extends CostManagementResource {
    private DimensionProperties innerProperties;
    private String etag;
    private String sku;
    private String type;
    private String name;
    private String id;

    private DimensionProperties innerProperties() {
        return this.innerProperties;
    }

    @Override
    public String etag() {
        return this.etag;
    }

    @Override
    public String sku() {
        return this.sku;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public DimensionInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    @Override
    public DimensionInner withTags(Map<String, String> tags) {
        super.withTags((Map)tags);
        return this;
    }

    public String description() {
        return this.innerProperties() == null ? null : this.innerProperties().description();
    }

    public Boolean filterEnabled() {
        return this.innerProperties() == null ? null : this.innerProperties().filterEnabled();
    }

    public Boolean groupingEnabled() {
        return this.innerProperties() == null ? null : this.innerProperties().groupingEnabled();
    }

    public List<String> data() {
        return this.innerProperties() == null ? null : this.innerProperties().data();
    }

    public DimensionInner withData(List<String> data) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DimensionProperties();
        }
        this.innerProperties().withData(data);
        return this;
    }

    public Integer total() {
        return this.innerProperties() == null ? null : this.innerProperties().total();
    }

    public String category() {
        return this.innerProperties() == null ? null : this.innerProperties().category();
    }

    public OffsetDateTime usageStart() {
        return this.innerProperties() == null ? null : this.innerProperties().usageStart();
    }

    public OffsetDateTime usageEnd() {
        return this.innerProperties() == null ? null : this.innerProperties().usageEnd();
    }

    public String nextLink() {
        return this.innerProperties() == null ? null : this.innerProperties().nextLink();
    }

    @Override
    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static DimensionInner fromJson(JsonReader jsonReader) throws IOException {
        return (DimensionInner)((Object)jsonReader.readObject(reader -> {
            DimensionInner deserializedDimensionInner = new DimensionInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedDimensionInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedDimensionInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedDimensionInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedDimensionInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedDimensionInner.withTags(tags);
                    continue;
                }
                if ("sku".equals(fieldName)) {
                    deserializedDimensionInner.sku = reader.getString();
                    continue;
                }
                if ("eTag".equals(fieldName)) {
                    deserializedDimensionInner.etag = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedDimensionInner.innerProperties = DimensionProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDimensionInner;
        }));
    }
}

