/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.costmanagement.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;

public final class DimensionProperties
implements JsonSerializable<DimensionProperties> {
    private String description;
    private Boolean filterEnabled;
    private Boolean groupingEnabled;
    private List<String> data;
    private Integer total;
    private String category;
    private OffsetDateTime usageStart;
    private OffsetDateTime usageEnd;
    private String nextLink;

    public String description() {
        return this.description;
    }

    public Boolean filterEnabled() {
        return this.filterEnabled;
    }

    public Boolean groupingEnabled() {
        return this.groupingEnabled;
    }

    public List<String> data() {
        return this.data;
    }

    public DimensionProperties withData(List<String> data) {
        this.data = data;
        return this;
    }

    public Integer total() {
        return this.total;
    }

    public String category() {
        return this.category;
    }

    public OffsetDateTime usageStart() {
        return this.usageStart;
    }

    public OffsetDateTime usageEnd() {
        return this.usageEnd;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("data", this.data, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static DimensionProperties fromJson(JsonReader jsonReader) throws IOException {
        return (DimensionProperties)jsonReader.readObject(reader -> {
            DimensionProperties deserializedDimensionProperties = new DimensionProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("description".equals(fieldName)) {
                    deserializedDimensionProperties.description = reader.getString();
                    continue;
                }
                if ("filterEnabled".equals(fieldName)) {
                    deserializedDimensionProperties.filterEnabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("groupingEnabled".equals(fieldName)) {
                    deserializedDimensionProperties.groupingEnabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("data".equals(fieldName)) {
                    List data;
                    deserializedDimensionProperties.data = data = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("total".equals(fieldName)) {
                    deserializedDimensionProperties.total = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("category".equals(fieldName)) {
                    deserializedDimensionProperties.category = reader.getString();
                    continue;
                }
                if ("usageStart".equals(fieldName)) {
                    deserializedDimensionProperties.usageStart = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("usageEnd".equals(fieldName)) {
                    deserializedDimensionProperties.usageEnd = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedDimensionProperties.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDimensionProperties;
        });
    }
}

