/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.costmanagement.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class DownloadUrlInner
implements JsonSerializable<DownloadUrlInner> {
    private OffsetDateTime expiryTime;
    private OffsetDateTime validTill;
    private String downloadUrl;

    public OffsetDateTime expiryTime() {
        return this.expiryTime;
    }

    public OffsetDateTime validTill() {
        return this.validTill;
    }

    public DownloadUrlInner withValidTill(OffsetDateTime validTill) {
        this.validTill = validTill;
        return this;
    }

    public String downloadUrl() {
        return this.downloadUrl;
    }

    public DownloadUrlInner withDownloadUrl(String downloadUrl) {
        this.downloadUrl = downloadUrl;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("validTill", this.validTill == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.validTill));
        jsonWriter.writeStringField("downloadUrl", this.downloadUrl);
        return jsonWriter.writeEndObject();
    }

    public static DownloadUrlInner fromJson(JsonReader jsonReader) throws IOException {
        return (DownloadUrlInner)jsonReader.readObject(reader -> {
            DownloadUrlInner deserializedDownloadUrlInner = new DownloadUrlInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("expiryTime".equals(fieldName)) {
                    deserializedDownloadUrlInner.expiryTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("validTill".equals(fieldName)) {
                    deserializedDownloadUrlInner.validTill = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("downloadUrl".equals(fieldName)) {
                    deserializedDownloadUrlInner.downloadUrl = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDownloadUrlInner;
        });
    }
}

