/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.costmanagement.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.costmanagement.fluent.models.ExportExecutionListResultInner;
import com.azure.resourcemanager.costmanagement.fluent.models.ExportProperties;
import com.azure.resourcemanager.costmanagement.models.CostManagementProxyResource;
import com.azure.resourcemanager.costmanagement.models.ExportDefinition;
import com.azure.resourcemanager.costmanagement.models.ExportDeliveryInfo;
import com.azure.resourcemanager.costmanagement.models.ExportSchedule;
import com.azure.resourcemanager.costmanagement.models.FormatType;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class ExportInner
extends CostManagementProxyResource {
    private ExportProperties innerProperties;
    private String type;
    private String name;
    private String id;

    private ExportProperties innerProperties() {
        return this.innerProperties;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public ExportInner withEtag(String etag) {
        super.withEtag(etag);
        return this;
    }

    public ExportSchedule schedule() {
        return this.innerProperties() == null ? null : this.innerProperties().schedule();
    }

    public ExportInner withSchedule(ExportSchedule schedule) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ExportProperties();
        }
        this.innerProperties().withSchedule(schedule);
        return this;
    }

    public FormatType format() {
        return this.innerProperties() == null ? null : this.innerProperties().format();
    }

    public ExportInner withFormat(FormatType format) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ExportProperties();
        }
        this.innerProperties().withFormat(format);
        return this;
    }

    public ExportDeliveryInfo deliveryInfo() {
        return this.innerProperties() == null ? null : this.innerProperties().deliveryInfo();
    }

    public ExportInner withDeliveryInfo(ExportDeliveryInfo deliveryInfo) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ExportProperties();
        }
        this.innerProperties().withDeliveryInfo(deliveryInfo);
        return this;
    }

    public ExportDefinition definition() {
        return this.innerProperties() == null ? null : this.innerProperties().definition();
    }

    public ExportInner withDefinition(ExportDefinition definition) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ExportProperties();
        }
        this.innerProperties().withDefinition(definition);
        return this;
    }

    public ExportExecutionListResultInner runHistory() {
        return this.innerProperties() == null ? null : this.innerProperties().runHistory();
    }

    public ExportInner withRunHistory(ExportExecutionListResultInner runHistory) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ExportProperties();
        }
        this.innerProperties().withRunHistory(runHistory);
        return this;
    }

    public Boolean partitionData() {
        return this.innerProperties() == null ? null : this.innerProperties().partitionData();
    }

    public ExportInner withPartitionData(Boolean partitionData) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ExportProperties();
        }
        this.innerProperties().withPartitionData(partitionData);
        return this;
    }

    public OffsetDateTime nextRunTimeEstimate() {
        return this.innerProperties() == null ? null : this.innerProperties().nextRunTimeEstimate();
    }

    @Override
    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("eTag", this.etag());
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static ExportInner fromJson(JsonReader jsonReader) throws IOException {
        return (ExportInner)((Object)jsonReader.readObject(reader -> {
            ExportInner deserializedExportInner = new ExportInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedExportInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedExportInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedExportInner.type = reader.getString();
                    continue;
                }
                if ("eTag".equals(fieldName)) {
                    deserializedExportInner.withEtag(reader.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedExportInner.innerProperties = ExportProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedExportInner;
        }));
    }
}

