/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.costmanagement.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.costmanagement.fluent.models.CommonExportPropertiesInner;
import com.azure.resourcemanager.costmanagement.fluent.models.ExportExecutionListResultInner;
import com.azure.resourcemanager.costmanagement.models.ExportDefinition;
import com.azure.resourcemanager.costmanagement.models.ExportDeliveryInfo;
import com.azure.resourcemanager.costmanagement.models.ExportSchedule;
import com.azure.resourcemanager.costmanagement.models.FormatType;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class ExportProperties
extends CommonExportPropertiesInner {
    private ExportSchedule schedule;
    private OffsetDateTime nextRunTimeEstimate;
    private static final ClientLogger LOGGER = new ClientLogger(ExportProperties.class);

    public ExportSchedule schedule() {
        return this.schedule;
    }

    public ExportProperties withSchedule(ExportSchedule schedule) {
        this.schedule = schedule;
        return this;
    }

    @Override
    public OffsetDateTime nextRunTimeEstimate() {
        return this.nextRunTimeEstimate;
    }

    @Override
    public ExportProperties withFormat(FormatType format) {
        super.withFormat(format);
        return this;
    }

    @Override
    public ExportProperties withDeliveryInfo(ExportDeliveryInfo deliveryInfo) {
        super.withDeliveryInfo(deliveryInfo);
        return this;
    }

    @Override
    public ExportProperties withDefinition(ExportDefinition definition) {
        super.withDefinition(definition);
        return this;
    }

    @Override
    public ExportProperties withRunHistory(ExportExecutionListResultInner runHistory) {
        super.withRunHistory(runHistory);
        return this;
    }

    @Override
    public ExportProperties withPartitionData(Boolean partitionData) {
        super.withPartitionData(partitionData);
        return this;
    }

    @Override
    public void validate() {
        if (this.schedule() != null) {
            this.schedule().validate();
        }
        if (this.deliveryInfo() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property deliveryInfo in model ExportProperties"));
        }
        this.deliveryInfo().validate();
        if (this.definition() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property definition in model ExportProperties"));
        }
        this.definition().validate();
        if (this.runHistory() != null) {
            this.runHistory().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("deliveryInfo", (JsonSerializable)this.deliveryInfo());
        jsonWriter.writeJsonField("definition", (JsonSerializable)this.definition());
        jsonWriter.writeStringField("format", this.format() == null ? null : this.format().toString());
        jsonWriter.writeJsonField("runHistory", (JsonSerializable)this.runHistory());
        jsonWriter.writeBooleanField("partitionData", this.partitionData());
        jsonWriter.writeJsonField("schedule", (JsonSerializable)this.schedule);
        return jsonWriter.writeEndObject();
    }

    public static ExportProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ExportProperties)jsonReader.readObject(reader -> {
            ExportProperties deserializedExportProperties = new ExportProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("deliveryInfo".equals(fieldName)) {
                    deserializedExportProperties.withDeliveryInfo(ExportDeliveryInfo.fromJson(reader));
                    continue;
                }
                if ("definition".equals(fieldName)) {
                    deserializedExportProperties.withDefinition(ExportDefinition.fromJson(reader));
                    continue;
                }
                if ("format".equals(fieldName)) {
                    deserializedExportProperties.withFormat(FormatType.fromString(reader.getString()));
                    continue;
                }
                if ("runHistory".equals(fieldName)) {
                    deserializedExportProperties.withRunHistory(ExportExecutionListResultInner.fromJson(reader));
                    continue;
                }
                if ("partitionData".equals(fieldName)) {
                    deserializedExportProperties.withPartitionData((Boolean)reader.getNullable(JsonReader::getBoolean));
                    continue;
                }
                if ("nextRunTimeEstimate".equals(fieldName)) {
                    deserializedExportProperties.nextRunTimeEstimate = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("schedule".equals(fieldName)) {
                    deserializedExportProperties.schedule = ExportSchedule.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedExportProperties;
        });
    }
}

