/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.costmanagement.fluent.models;

import com.azure.core.management.exception.ManagementError;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.costmanagement.fluent.models.CommonExportPropertiesInner;
import com.azure.resourcemanager.costmanagement.fluent.models.ExportRunPropertiesInner;
import com.azure.resourcemanager.costmanagement.models.CostManagementProxyResource;
import com.azure.resourcemanager.costmanagement.models.ExecutionStatus;
import com.azure.resourcemanager.costmanagement.models.ExecutionType;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class ExportRunInner
extends CostManagementProxyResource {
    private ExportRunPropertiesInner innerProperties;
    private String type;
    private String name;
    private String id;

    private ExportRunPropertiesInner innerProperties() {
        return this.innerProperties;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public ExportRunInner withEtag(String etag) {
        super.withEtag(etag);
        return this;
    }

    public ExecutionType executionType() {
        return this.innerProperties() == null ? null : this.innerProperties().executionType();
    }

    public ExportRunInner withExecutionType(ExecutionType executionType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ExportRunPropertiesInner();
        }
        this.innerProperties().withExecutionType(executionType);
        return this;
    }

    public ExecutionStatus status() {
        return this.innerProperties() == null ? null : this.innerProperties().status();
    }

    public ExportRunInner withStatus(ExecutionStatus status) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ExportRunPropertiesInner();
        }
        this.innerProperties().withStatus(status);
        return this;
    }

    public String submittedBy() {
        return this.innerProperties() == null ? null : this.innerProperties().submittedBy();
    }

    public ExportRunInner withSubmittedBy(String submittedBy) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ExportRunPropertiesInner();
        }
        this.innerProperties().withSubmittedBy(submittedBy);
        return this;
    }

    public OffsetDateTime submittedTime() {
        return this.innerProperties() == null ? null : this.innerProperties().submittedTime();
    }

    public ExportRunInner withSubmittedTime(OffsetDateTime submittedTime) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ExportRunPropertiesInner();
        }
        this.innerProperties().withSubmittedTime(submittedTime);
        return this;
    }

    public OffsetDateTime processingStartTime() {
        return this.innerProperties() == null ? null : this.innerProperties().processingStartTime();
    }

    public ExportRunInner withProcessingStartTime(OffsetDateTime processingStartTime) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ExportRunPropertiesInner();
        }
        this.innerProperties().withProcessingStartTime(processingStartTime);
        return this;
    }

    public OffsetDateTime processingEndTime() {
        return this.innerProperties() == null ? null : this.innerProperties().processingEndTime();
    }

    public ExportRunInner withProcessingEndTime(OffsetDateTime processingEndTime) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ExportRunPropertiesInner();
        }
        this.innerProperties().withProcessingEndTime(processingEndTime);
        return this;
    }

    public String fileName() {
        return this.innerProperties() == null ? null : this.innerProperties().fileName();
    }

    public ExportRunInner withFileName(String fileName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ExportRunPropertiesInner();
        }
        this.innerProperties().withFileName(fileName);
        return this;
    }

    public CommonExportPropertiesInner runSettings() {
        return this.innerProperties() == null ? null : this.innerProperties().runSettings();
    }

    public ExportRunInner withRunSettings(CommonExportPropertiesInner runSettings) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ExportRunPropertiesInner();
        }
        this.innerProperties().withRunSettings(runSettings);
        return this;
    }

    public ManagementError error() {
        return this.innerProperties() == null ? null : this.innerProperties().error();
    }

    public ExportRunInner withError(ManagementError error) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ExportRunPropertiesInner();
        }
        this.innerProperties().withError(error);
        return this;
    }

    @Override
    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("eTag", this.etag());
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static ExportRunInner fromJson(JsonReader jsonReader) throws IOException {
        return (ExportRunInner)((Object)jsonReader.readObject(reader -> {
            ExportRunInner deserializedExportRunInner = new ExportRunInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedExportRunInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedExportRunInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedExportRunInner.type = reader.getString();
                    continue;
                }
                if ("eTag".equals(fieldName)) {
                    deserializedExportRunInner.withEtag(reader.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedExportRunInner.innerProperties = ExportRunPropertiesInner.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedExportRunInner;
        }));
    }
}

