/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.costmanagement.fluent.models;

import com.azure.core.management.exception.ManagementError;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.costmanagement.fluent.models.CommonExportPropertiesInner;
import com.azure.resourcemanager.costmanagement.models.ExecutionStatus;
import com.azure.resourcemanager.costmanagement.models.ExecutionType;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class ExportRunPropertiesInner
implements JsonSerializable<ExportRunPropertiesInner> {
    private ExecutionType executionType;
    private ExecutionStatus status;
    private String submittedBy;
    private OffsetDateTime submittedTime;
    private OffsetDateTime processingStartTime;
    private OffsetDateTime processingEndTime;
    private String fileName;
    private CommonExportPropertiesInner runSettings;
    private ManagementError error;

    public ExecutionType executionType() {
        return this.executionType;
    }

    public ExportRunPropertiesInner withExecutionType(ExecutionType executionType) {
        this.executionType = executionType;
        return this;
    }

    public ExecutionStatus status() {
        return this.status;
    }

    public ExportRunPropertiesInner withStatus(ExecutionStatus status) {
        this.status = status;
        return this;
    }

    public String submittedBy() {
        return this.submittedBy;
    }

    public ExportRunPropertiesInner withSubmittedBy(String submittedBy) {
        this.submittedBy = submittedBy;
        return this;
    }

    public OffsetDateTime submittedTime() {
        return this.submittedTime;
    }

    public ExportRunPropertiesInner withSubmittedTime(OffsetDateTime submittedTime) {
        this.submittedTime = submittedTime;
        return this;
    }

    public OffsetDateTime processingStartTime() {
        return this.processingStartTime;
    }

    public ExportRunPropertiesInner withProcessingStartTime(OffsetDateTime processingStartTime) {
        this.processingStartTime = processingStartTime;
        return this;
    }

    public OffsetDateTime processingEndTime() {
        return this.processingEndTime;
    }

    public ExportRunPropertiesInner withProcessingEndTime(OffsetDateTime processingEndTime) {
        this.processingEndTime = processingEndTime;
        return this;
    }

    public String fileName() {
        return this.fileName;
    }

    public ExportRunPropertiesInner withFileName(String fileName) {
        this.fileName = fileName;
        return this;
    }

    public CommonExportPropertiesInner runSettings() {
        return this.runSettings;
    }

    public ExportRunPropertiesInner withRunSettings(CommonExportPropertiesInner runSettings) {
        this.runSettings = runSettings;
        return this;
    }

    public ManagementError error() {
        return this.error;
    }

    public ExportRunPropertiesInner withError(ManagementError error) {
        this.error = error;
        return this;
    }

    public void validate() {
        if (this.runSettings() != null) {
            this.runSettings().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("executionType", this.executionType == null ? null : this.executionType.toString());
        jsonWriter.writeStringField("status", this.status == null ? null : this.status.toString());
        jsonWriter.writeStringField("submittedBy", this.submittedBy);
        jsonWriter.writeStringField("submittedTime", this.submittedTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.submittedTime));
        jsonWriter.writeStringField("processingStartTime", this.processingStartTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.processingStartTime));
        jsonWriter.writeStringField("processingEndTime", this.processingEndTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.processingEndTime));
        jsonWriter.writeStringField("fileName", this.fileName);
        jsonWriter.writeJsonField("runSettings", (JsonSerializable)this.runSettings);
        jsonWriter.writeJsonField("error", (JsonSerializable)this.error);
        return jsonWriter.writeEndObject();
    }

    public static ExportRunPropertiesInner fromJson(JsonReader jsonReader) throws IOException {
        return (ExportRunPropertiesInner)jsonReader.readObject(reader -> {
            ExportRunPropertiesInner deserializedExportRunPropertiesInner = new ExportRunPropertiesInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("executionType".equals(fieldName)) {
                    deserializedExportRunPropertiesInner.executionType = ExecutionType.fromString(reader.getString());
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedExportRunPropertiesInner.status = ExecutionStatus.fromString(reader.getString());
                    continue;
                }
                if ("submittedBy".equals(fieldName)) {
                    deserializedExportRunPropertiesInner.submittedBy = reader.getString();
                    continue;
                }
                if ("submittedTime".equals(fieldName)) {
                    deserializedExportRunPropertiesInner.submittedTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("processingStartTime".equals(fieldName)) {
                    deserializedExportRunPropertiesInner.processingStartTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("processingEndTime".equals(fieldName)) {
                    deserializedExportRunPropertiesInner.processingEndTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("fileName".equals(fieldName)) {
                    deserializedExportRunPropertiesInner.fileName = reader.getString();
                    continue;
                }
                if ("runSettings".equals(fieldName)) {
                    deserializedExportRunPropertiesInner.runSettings = CommonExportPropertiesInner.fromJson(reader);
                    continue;
                }
                if ("error".equals(fieldName)) {
                    deserializedExportRunPropertiesInner.error = ManagementError.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedExportRunPropertiesInner;
        });
    }
}

