/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.costmanagement.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.costmanagement.models.ForecastColumn;
import java.io.IOException;
import java.util.List;

public final class ForecastProperties
implements JsonSerializable<ForecastProperties> {
    private String nextLink;
    private List<ForecastColumn> columns;
    private List<List<Object>> rows;

    public String nextLink() {
        return this.nextLink;
    }

    public ForecastProperties withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    public List<ForecastColumn> columns() {
        return this.columns;
    }

    public ForecastProperties withColumns(List<ForecastColumn> columns) {
        this.columns = columns;
        return this;
    }

    public List<List<Object>> rows() {
        return this.rows;
    }

    public ForecastProperties withRows(List<List<Object>> rows) {
        this.rows = rows;
        return this;
    }

    public void validate() {
        if (this.columns() != null) {
            this.columns().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("nextLink", this.nextLink);
        jsonWriter.writeArrayField("columns", this.columns, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("rows", this.rows, (writer, element) -> writer.writeArray((Iterable)element, (writer1, element1) -> writer1.writeUntyped(element1)));
        return jsonWriter.writeEndObject();
    }

    public static ForecastProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ForecastProperties)jsonReader.readObject(reader -> {
            ForecastProperties deserializedForecastProperties = new ForecastProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("nextLink".equals(fieldName)) {
                    deserializedForecastProperties.nextLink = reader.getString();
                    continue;
                }
                if ("columns".equals(fieldName)) {
                    List columns;
                    deserializedForecastProperties.columns = columns = reader.readArray(reader1 -> ForecastColumn.fromJson(reader1));
                    continue;
                }
                if ("rows".equals(fieldName)) {
                    List rows;
                    deserializedForecastProperties.rows = rows = reader.readArray(reader1 -> reader1.readArray(reader2 -> reader2.readUntyped()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedForecastProperties;
        });
    }
}

