/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.costmanagement.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.costmanagement.fluent.models.ForecastProperties;
import com.azure.resourcemanager.costmanagement.models.CostManagementResource;
import com.azure.resourcemanager.costmanagement.models.ForecastColumn;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class ForecastResultInner
extends CostManagementResource {
    private ForecastProperties innerProperties;
    private String etag;
    private String sku;
    private String type;
    private String name;
    private String id;

    private ForecastProperties innerProperties() {
        return this.innerProperties;
    }

    @Override
    public String etag() {
        return this.etag;
    }

    @Override
    public String sku() {
        return this.sku;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public ForecastResultInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    @Override
    public ForecastResultInner withTags(Map<String, String> tags) {
        super.withTags((Map)tags);
        return this;
    }

    public String nextLink() {
        return this.innerProperties() == null ? null : this.innerProperties().nextLink();
    }

    public ForecastResultInner withNextLink(String nextLink) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ForecastProperties();
        }
        this.innerProperties().withNextLink(nextLink);
        return this;
    }

    public List<ForecastColumn> columns() {
        return this.innerProperties() == null ? null : this.innerProperties().columns();
    }

    public ForecastResultInner withColumns(List<ForecastColumn> columns) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ForecastProperties();
        }
        this.innerProperties().withColumns(columns);
        return this;
    }

    public List<List<Object>> rows() {
        return this.innerProperties() == null ? null : this.innerProperties().rows();
    }

    public ForecastResultInner withRows(List<List<Object>> rows) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ForecastProperties();
        }
        this.innerProperties().withRows(rows);
        return this;
    }

    @Override
    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static ForecastResultInner fromJson(JsonReader jsonReader) throws IOException {
        return (ForecastResultInner)((Object)jsonReader.readObject(reader -> {
            ForecastResultInner deserializedForecastResultInner = new ForecastResultInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedForecastResultInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedForecastResultInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedForecastResultInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedForecastResultInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedForecastResultInner.withTags(tags);
                    continue;
                }
                if ("sku".equals(fieldName)) {
                    deserializedForecastResultInner.sku = reader.getString();
                    continue;
                }
                if ("eTag".equals(fieldName)) {
                    deserializedForecastResultInner.etag = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedForecastResultInner.innerProperties = ForecastProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedForecastResultInner;
        }));
    }
}

