/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.costmanagement.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.costmanagement.models.BenefitKind;
import com.azure.resourcemanager.costmanagement.models.BenefitUtilizationSummaryProperties;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.OffsetDateTime;

public final class IncludedQuantityUtilizationSummaryProperties
extends BenefitUtilizationSummaryProperties {
    private BigDecimal utilizationPercentage;
    private OffsetDateTime usageDate;
    private String benefitOrderId;
    private String benefitId;
    private String armSkuName;

    public BigDecimal utilizationPercentage() {
        return this.utilizationPercentage;
    }

    @Override
    public OffsetDateTime usageDate() {
        return this.usageDate;
    }

    @Override
    public String benefitOrderId() {
        return this.benefitOrderId;
    }

    @Override
    public String benefitId() {
        return this.benefitId;
    }

    @Override
    public String armSkuName() {
        return this.armSkuName;
    }

    @Override
    public IncludedQuantityUtilizationSummaryProperties withBenefitType(BenefitKind benefitType) {
        super.withBenefitType(benefitType);
        return this;
    }

    @Override
    public void validate() {
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("benefitType", this.benefitType() == null ? null : this.benefitType().toString());
        return jsonWriter.writeEndObject();
    }

    public static IncludedQuantityUtilizationSummaryProperties fromJson(JsonReader jsonReader) throws IOException {
        return (IncludedQuantityUtilizationSummaryProperties)jsonReader.readObject(reader -> {
            IncludedQuantityUtilizationSummaryProperties deserializedIncludedQuantityUtilizationSummaryProperties = new IncludedQuantityUtilizationSummaryProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("armSkuName".equals(fieldName)) {
                    deserializedIncludedQuantityUtilizationSummaryProperties.armSkuName = reader.getString();
                    continue;
                }
                if ("benefitId".equals(fieldName)) {
                    deserializedIncludedQuantityUtilizationSummaryProperties.benefitId = reader.getString();
                    continue;
                }
                if ("benefitOrderId".equals(fieldName)) {
                    deserializedIncludedQuantityUtilizationSummaryProperties.benefitOrderId = reader.getString();
                    continue;
                }
                if ("benefitType".equals(fieldName)) {
                    deserializedIncludedQuantityUtilizationSummaryProperties.withBenefitType(BenefitKind.fromString(reader.getString()));
                    continue;
                }
                if ("usageDate".equals(fieldName)) {
                    deserializedIncludedQuantityUtilizationSummaryProperties.usageDate = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("utilizationPercentage".equals(fieldName)) {
                    deserializedIncludedQuantityUtilizationSummaryProperties.utilizationPercentage = (BigDecimal)reader.getNullable(nonNullReader -> new BigDecimal(nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedIncludedQuantityUtilizationSummaryProperties;
        });
    }
}

