/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.costmanagement.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.costmanagement.fluent.models.ReportUrl;
import com.azure.resourcemanager.costmanagement.models.OperationStatusType;
import com.azure.resourcemanager.costmanagement.models.ReservationReportSchema;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class OperationStatusInner
implements JsonSerializable<OperationStatusInner> {
    private OperationStatusType status;
    private ReportUrl innerProperties;

    public OperationStatusType status() {
        return this.status;
    }

    public OperationStatusInner withStatus(OperationStatusType status) {
        this.status = status;
        return this;
    }

    private ReportUrl innerProperties() {
        return this.innerProperties;
    }

    public ReservationReportSchema reportUrl() {
        return this.innerProperties() == null ? null : this.innerProperties().reportUrl();
    }

    public OperationStatusInner withReportUrl(ReservationReportSchema reportUrl) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ReportUrl();
        }
        this.innerProperties().withReportUrl(reportUrl);
        return this;
    }

    public OffsetDateTime validUntil() {
        return this.innerProperties() == null ? null : this.innerProperties().validUntil();
    }

    public OperationStatusInner withValidUntil(OffsetDateTime validUntil) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ReportUrl();
        }
        this.innerProperties().withValidUntil(validUntil);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("status", this.status == null ? null : this.status.toString());
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static OperationStatusInner fromJson(JsonReader jsonReader) throws IOException {
        return (OperationStatusInner)jsonReader.readObject(reader -> {
            OperationStatusInner deserializedOperationStatusInner = new OperationStatusInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("status".equals(fieldName)) {
                    deserializedOperationStatusInner.status = OperationStatusType.fromString(reader.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedOperationStatusInner.innerProperties = ReportUrl.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedOperationStatusInner;
        });
    }
}

