/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.costmanagement.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.costmanagement.models.ReportConfigDataset;
import com.azure.resourcemanager.costmanagement.models.ReportConfigTimePeriod;
import com.azure.resourcemanager.costmanagement.models.ReportTimeframeType;
import com.azure.resourcemanager.costmanagement.models.ReportType;
import java.io.IOException;

public final class ReportConfigDefinition
implements JsonSerializable<ReportConfigDefinition> {
    private ReportType type;
    private ReportTimeframeType timeframe;
    private ReportConfigTimePeriod timePeriod;
    private ReportConfigDataset dataSet;
    private Boolean includeMonetaryCommitment;
    private static final ClientLogger LOGGER = new ClientLogger(ReportConfigDefinition.class);

    public ReportType type() {
        return this.type;
    }

    public ReportConfigDefinition withType(ReportType type) {
        this.type = type;
        return this;
    }

    public ReportTimeframeType timeframe() {
        return this.timeframe;
    }

    public ReportConfigDefinition withTimeframe(ReportTimeframeType timeframe) {
        this.timeframe = timeframe;
        return this;
    }

    public ReportConfigTimePeriod timePeriod() {
        return this.timePeriod;
    }

    public ReportConfigDefinition withTimePeriod(ReportConfigTimePeriod timePeriod) {
        this.timePeriod = timePeriod;
        return this;
    }

    public ReportConfigDataset dataSet() {
        return this.dataSet;
    }

    public ReportConfigDefinition withDataSet(ReportConfigDataset dataSet) {
        this.dataSet = dataSet;
        return this;
    }

    public Boolean includeMonetaryCommitment() {
        return this.includeMonetaryCommitment;
    }

    public ReportConfigDefinition withIncludeMonetaryCommitment(Boolean includeMonetaryCommitment) {
        this.includeMonetaryCommitment = includeMonetaryCommitment;
        return this;
    }

    public void validate() {
        if (this.type() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property type in model ReportConfigDefinition"));
        }
        if (this.timeframe() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property timeframe in model ReportConfigDefinition"));
        }
        if (this.timePeriod() != null) {
            this.timePeriod().validate();
        }
        if (this.dataSet() != null) {
            this.dataSet().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeStringField("timeframe", this.timeframe == null ? null : this.timeframe.toString());
        jsonWriter.writeJsonField("timePeriod", (JsonSerializable)this.timePeriod);
        jsonWriter.writeJsonField("dataSet", (JsonSerializable)this.dataSet);
        jsonWriter.writeBooleanField("includeMonetaryCommitment", this.includeMonetaryCommitment);
        return jsonWriter.writeEndObject();
    }

    public static ReportConfigDefinition fromJson(JsonReader jsonReader) throws IOException {
        return (ReportConfigDefinition)jsonReader.readObject(reader -> {
            ReportConfigDefinition deserializedReportConfigDefinition = new ReportConfigDefinition();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    deserializedReportConfigDefinition.type = ReportType.fromString(reader.getString());
                    continue;
                }
                if ("timeframe".equals(fieldName)) {
                    deserializedReportConfigDefinition.timeframe = ReportTimeframeType.fromString(reader.getString());
                    continue;
                }
                if ("timePeriod".equals(fieldName)) {
                    deserializedReportConfigDefinition.timePeriod = ReportConfigTimePeriod.fromJson(reader);
                    continue;
                }
                if ("dataSet".equals(fieldName)) {
                    deserializedReportConfigDefinition.dataSet = ReportConfigDataset.fromJson(reader);
                    continue;
                }
                if ("includeMonetaryCommitment".equals(fieldName)) {
                    deserializedReportConfigDefinition.includeMonetaryCommitment = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedReportConfigDefinition;
        });
    }
}

