/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.costmanagement.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.costmanagement.fluent.models.RequestContext;
import com.azure.resourcemanager.costmanagement.models.BlobInfo;
import com.azure.resourcemanager.costmanagement.models.CostDetailsDataFormat;
import com.azure.resourcemanager.costmanagement.models.GenerateCostDetailsReportRequestDefinition;
import java.io.IOException;
import java.util.List;

public final class ReportManifest
implements JsonSerializable<ReportManifest> {
    private String manifestVersion;
    private CostDetailsDataFormat dataFormat;
    private Long byteCount;
    private Integer blobCount;
    private Boolean compressData;
    private RequestContext innerRequestContext;
    private List<BlobInfo> blobs;

    public String manifestVersion() {
        return this.manifestVersion;
    }

    public ReportManifest withManifestVersion(String manifestVersion) {
        this.manifestVersion = manifestVersion;
        return this;
    }

    public CostDetailsDataFormat dataFormat() {
        return this.dataFormat;
    }

    public ReportManifest withDataFormat(CostDetailsDataFormat dataFormat) {
        this.dataFormat = dataFormat;
        return this;
    }

    public Long byteCount() {
        return this.byteCount;
    }

    public ReportManifest withByteCount(Long byteCount) {
        this.byteCount = byteCount;
        return this;
    }

    public Integer blobCount() {
        return this.blobCount;
    }

    public ReportManifest withBlobCount(Integer blobCount) {
        this.blobCount = blobCount;
        return this;
    }

    public Boolean compressData() {
        return this.compressData;
    }

    public ReportManifest withCompressData(Boolean compressData) {
        this.compressData = compressData;
        return this;
    }

    private RequestContext innerRequestContext() {
        return this.innerRequestContext;
    }

    public List<BlobInfo> blobs() {
        return this.blobs;
    }

    public ReportManifest withBlobs(List<BlobInfo> blobs) {
        this.blobs = blobs;
        return this;
    }

    public String requestScope() {
        return this.innerRequestContext() == null ? null : this.innerRequestContext().requestScope();
    }

    public ReportManifest withRequestScope(String requestScope) {
        if (this.innerRequestContext() == null) {
            this.innerRequestContext = new RequestContext();
        }
        this.innerRequestContext().withRequestScope(requestScope);
        return this;
    }

    public GenerateCostDetailsReportRequestDefinition requestBody() {
        return this.innerRequestContext() == null ? null : this.innerRequestContext().requestBody();
    }

    public ReportManifest withRequestBody(GenerateCostDetailsReportRequestDefinition requestBody) {
        if (this.innerRequestContext() == null) {
            this.innerRequestContext = new RequestContext();
        }
        this.innerRequestContext().withRequestBody(requestBody);
        return this;
    }

    public void validate() {
        if (this.innerRequestContext() != null) {
            this.innerRequestContext().validate();
        }
        if (this.blobs() != null) {
            this.blobs().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("manifestVersion", this.manifestVersion);
        jsonWriter.writeStringField("dataFormat", this.dataFormat == null ? null : this.dataFormat.toString());
        jsonWriter.writeNumberField("byteCount", (Number)this.byteCount);
        jsonWriter.writeNumberField("blobCount", (Number)this.blobCount);
        jsonWriter.writeBooleanField("compressData", this.compressData);
        jsonWriter.writeJsonField("requestContext", (JsonSerializable)this.innerRequestContext);
        jsonWriter.writeArrayField("blobs", this.blobs, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static ReportManifest fromJson(JsonReader jsonReader) throws IOException {
        return (ReportManifest)jsonReader.readObject(reader -> {
            ReportManifest deserializedReportManifest = new ReportManifest();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("manifestVersion".equals(fieldName)) {
                    deserializedReportManifest.manifestVersion = reader.getString();
                    continue;
                }
                if ("dataFormat".equals(fieldName)) {
                    deserializedReportManifest.dataFormat = CostDetailsDataFormat.fromString(reader.getString());
                    continue;
                }
                if ("byteCount".equals(fieldName)) {
                    deserializedReportManifest.byteCount = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("blobCount".equals(fieldName)) {
                    deserializedReportManifest.blobCount = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("compressData".equals(fieldName)) {
                    deserializedReportManifest.compressData = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("requestContext".equals(fieldName)) {
                    deserializedReportManifest.innerRequestContext = RequestContext.fromJson(reader);
                    continue;
                }
                if ("blobs".equals(fieldName)) {
                    List blobs;
                    deserializedReportManifest.blobs = blobs = reader.readArray(reader1 -> BlobInfo.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedReportManifest;
        });
    }
}

