/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.costmanagement.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.costmanagement.models.ReservationReportSchema;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class ReportUrl
implements JsonSerializable<ReportUrl> {
    private ReservationReportSchema reportUrl;
    private OffsetDateTime validUntil;

    public ReservationReportSchema reportUrl() {
        return this.reportUrl;
    }

    public ReportUrl withReportUrl(ReservationReportSchema reportUrl) {
        this.reportUrl = reportUrl;
        return this;
    }

    public OffsetDateTime validUntil() {
        return this.validUntil;
    }

    public ReportUrl withValidUntil(OffsetDateTime validUntil) {
        this.validUntil = validUntil;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("reportUrl", this.reportUrl == null ? null : this.reportUrl.toString());
        jsonWriter.writeStringField("validUntil", this.validUntil == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.validUntil));
        return jsonWriter.writeEndObject();
    }

    public static ReportUrl fromJson(JsonReader jsonReader) throws IOException {
        return (ReportUrl)jsonReader.readObject(reader -> {
            ReportUrl deserializedReportUrl = new ReportUrl();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("reportUrl".equals(fieldName)) {
                    deserializedReportUrl.reportUrl = ReservationReportSchema.fromString(reader.getString());
                    continue;
                }
                if ("validUntil".equals(fieldName)) {
                    deserializedReportUrl.validUntil = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedReportUrl;
        });
    }
}

