/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.costmanagement.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.costmanagement.models.GenerateCostDetailsReportRequestDefinition;
import java.io.IOException;

public final class RequestContext
implements JsonSerializable<RequestContext> {
    private String requestScope;
    private GenerateCostDetailsReportRequestDefinition requestBody;

    public String requestScope() {
        return this.requestScope;
    }

    public RequestContext withRequestScope(String requestScope) {
        this.requestScope = requestScope;
        return this;
    }

    public GenerateCostDetailsReportRequestDefinition requestBody() {
        return this.requestBody;
    }

    public RequestContext withRequestBody(GenerateCostDetailsReportRequestDefinition requestBody) {
        this.requestBody = requestBody;
        return this;
    }

    public void validate() {
        if (this.requestBody() != null) {
            this.requestBody().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("requestScope", this.requestScope);
        jsonWriter.writeJsonField("requestBody", (JsonSerializable)this.requestBody);
        return jsonWriter.writeEndObject();
    }

    public static RequestContext fromJson(JsonReader jsonReader) throws IOException {
        return (RequestContext)jsonReader.readObject(reader -> {
            RequestContext deserializedRequestContext = new RequestContext();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("requestScope".equals(fieldName)) {
                    deserializedRequestContext.requestScope = reader.getString();
                    continue;
                }
                if ("requestBody".equals(fieldName)) {
                    deserializedRequestContext.requestBody = GenerateCostDetailsReportRequestDefinition.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRequestContext;
        });
    }
}

