/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.costmanagement.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.costmanagement.models.BenefitKind;
import com.azure.resourcemanager.costmanagement.models.BenefitUtilizationSummaryProperties;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.OffsetDateTime;

public final class SavingsPlanUtilizationSummaryProperties
extends BenefitUtilizationSummaryProperties {
    private BigDecimal avgUtilizationPercentage;
    private BigDecimal minUtilizationPercentage;
    private BigDecimal maxUtilizationPercentage;
    private OffsetDateTime usageDate;
    private String benefitOrderId;
    private String benefitId;
    private String armSkuName;

    public BigDecimal avgUtilizationPercentage() {
        return this.avgUtilizationPercentage;
    }

    public BigDecimal minUtilizationPercentage() {
        return this.minUtilizationPercentage;
    }

    public BigDecimal maxUtilizationPercentage() {
        return this.maxUtilizationPercentage;
    }

    @Override
    public OffsetDateTime usageDate() {
        return this.usageDate;
    }

    @Override
    public String benefitOrderId() {
        return this.benefitOrderId;
    }

    @Override
    public String benefitId() {
        return this.benefitId;
    }

    @Override
    public String armSkuName() {
        return this.armSkuName;
    }

    @Override
    public SavingsPlanUtilizationSummaryProperties withBenefitType(BenefitKind benefitType) {
        super.withBenefitType(benefitType);
        return this;
    }

    @Override
    public void validate() {
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("benefitType", this.benefitType() == null ? null : this.benefitType().toString());
        return jsonWriter.writeEndObject();
    }

    public static SavingsPlanUtilizationSummaryProperties fromJson(JsonReader jsonReader) throws IOException {
        return (SavingsPlanUtilizationSummaryProperties)jsonReader.readObject(reader -> {
            SavingsPlanUtilizationSummaryProperties deserializedSavingsPlanUtilizationSummaryProperties = new SavingsPlanUtilizationSummaryProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("armSkuName".equals(fieldName)) {
                    deserializedSavingsPlanUtilizationSummaryProperties.armSkuName = reader.getString();
                    continue;
                }
                if ("benefitId".equals(fieldName)) {
                    deserializedSavingsPlanUtilizationSummaryProperties.benefitId = reader.getString();
                    continue;
                }
                if ("benefitOrderId".equals(fieldName)) {
                    deserializedSavingsPlanUtilizationSummaryProperties.benefitOrderId = reader.getString();
                    continue;
                }
                if ("benefitType".equals(fieldName)) {
                    deserializedSavingsPlanUtilizationSummaryProperties.withBenefitType(BenefitKind.fromString(reader.getString()));
                    continue;
                }
                if ("usageDate".equals(fieldName)) {
                    deserializedSavingsPlanUtilizationSummaryProperties.usageDate = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("avgUtilizationPercentage".equals(fieldName)) {
                    deserializedSavingsPlanUtilizationSummaryProperties.avgUtilizationPercentage = (BigDecimal)reader.getNullable(nonNullReader -> new BigDecimal(nonNullReader.getString()));
                    continue;
                }
                if ("minUtilizationPercentage".equals(fieldName)) {
                    deserializedSavingsPlanUtilizationSummaryProperties.minUtilizationPercentage = (BigDecimal)reader.getNullable(nonNullReader -> new BigDecimal(nonNullReader.getString()));
                    continue;
                }
                if ("maxUtilizationPercentage".equals(fieldName)) {
                    deserializedSavingsPlanUtilizationSummaryProperties.maxUtilizationPercentage = (BigDecimal)reader.getNullable(nonNullReader -> new BigDecimal(nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSavingsPlanUtilizationSummaryProperties;
        });
    }
}

