/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.costmanagement.fluent.models;

import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.costmanagement.fluent.models.ScheduledActionProperties;
import com.azure.resourcemanager.costmanagement.models.FileDestination;
import com.azure.resourcemanager.costmanagement.models.NotificationProperties;
import com.azure.resourcemanager.costmanagement.models.ScheduleProperties;
import com.azure.resourcemanager.costmanagement.models.ScheduledActionKind;
import com.azure.resourcemanager.costmanagement.models.ScheduledActionProxyResource;
import com.azure.resourcemanager.costmanagement.models.ScheduledActionStatus;
import java.io.IOException;

public final class ScheduledActionInner
extends ScheduledActionProxyResource {
    private ScheduledActionProperties innerProperties;
    private SystemData systemData;
    private String etag;
    private String type;
    private String name;
    private String id;

    private ScheduledActionProperties innerProperties() {
        return this.innerProperties;
    }

    @Override
    public SystemData systemData() {
        return this.systemData;
    }

    @Override
    public String etag() {
        return this.etag;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public ScheduledActionInner withKind(ScheduledActionKind kind) {
        super.withKind(kind);
        return this;
    }

    public String displayName() {
        return this.innerProperties() == null ? null : this.innerProperties().displayName();
    }

    public ScheduledActionInner withDisplayName(String displayName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ScheduledActionProperties();
        }
        this.innerProperties().withDisplayName(displayName);
        return this;
    }

    public FileDestination fileDestination() {
        return this.innerProperties() == null ? null : this.innerProperties().fileDestination();
    }

    public ScheduledActionInner withFileDestination(FileDestination fileDestination) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ScheduledActionProperties();
        }
        this.innerProperties().withFileDestination(fileDestination);
        return this;
    }

    public NotificationProperties notification() {
        return this.innerProperties() == null ? null : this.innerProperties().notification();
    }

    public ScheduledActionInner withNotification(NotificationProperties notification) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ScheduledActionProperties();
        }
        this.innerProperties().withNotification(notification);
        return this;
    }

    public String notificationEmail() {
        return this.innerProperties() == null ? null : this.innerProperties().notificationEmail();
    }

    public ScheduledActionInner withNotificationEmail(String notificationEmail) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ScheduledActionProperties();
        }
        this.innerProperties().withNotificationEmail(notificationEmail);
        return this;
    }

    public ScheduleProperties schedule() {
        return this.innerProperties() == null ? null : this.innerProperties().schedule();
    }

    public ScheduledActionInner withSchedule(ScheduleProperties schedule) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ScheduledActionProperties();
        }
        this.innerProperties().withSchedule(schedule);
        return this;
    }

    public String scope() {
        return this.innerProperties() == null ? null : this.innerProperties().scope();
    }

    public ScheduledActionInner withScope(String scope) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ScheduledActionProperties();
        }
        this.innerProperties().withScope(scope);
        return this;
    }

    public ScheduledActionStatus status() {
        return this.innerProperties() == null ? null : this.innerProperties().status();
    }

    public ScheduledActionInner withStatus(ScheduledActionStatus status) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ScheduledActionProperties();
        }
        this.innerProperties().withStatus(status);
        return this;
    }

    public String viewId() {
        return this.innerProperties() == null ? null : this.innerProperties().viewId();
    }

    public ScheduledActionInner withViewId(String viewId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ScheduledActionProperties();
        }
        this.innerProperties().withViewId(viewId);
        return this;
    }

    @Override
    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kind", this.kind() == null ? null : this.kind().toString());
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static ScheduledActionInner fromJson(JsonReader jsonReader) throws IOException {
        return (ScheduledActionInner)((Object)jsonReader.readObject(reader -> {
            ScheduledActionInner deserializedScheduledActionInner = new ScheduledActionInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedScheduledActionInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedScheduledActionInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedScheduledActionInner.type = reader.getString();
                    continue;
                }
                if ("eTag".equals(fieldName)) {
                    deserializedScheduledActionInner.etag = reader.getString();
                    continue;
                }
                if ("kind".equals(fieldName)) {
                    deserializedScheduledActionInner.withKind(ScheduledActionKind.fromString(reader.getString()));
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedScheduledActionInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedScheduledActionInner.innerProperties = ScheduledActionProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedScheduledActionInner;
        }));
    }
}

