/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.costmanagement.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.costmanagement.models.FileDestination;
import com.azure.resourcemanager.costmanagement.models.NotificationProperties;
import com.azure.resourcemanager.costmanagement.models.ScheduleProperties;
import com.azure.resourcemanager.costmanagement.models.ScheduledActionStatus;
import java.io.IOException;

public final class ScheduledActionProperties
implements JsonSerializable<ScheduledActionProperties> {
    private String displayName;
    private FileDestination fileDestination;
    private NotificationProperties notification;
    private String notificationEmail;
    private ScheduleProperties schedule;
    private String scope;
    private ScheduledActionStatus status;
    private String viewId;
    private static final ClientLogger LOGGER = new ClientLogger(ScheduledActionProperties.class);

    public String displayName() {
        return this.displayName;
    }

    public ScheduledActionProperties withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    public FileDestination fileDestination() {
        return this.fileDestination;
    }

    public ScheduledActionProperties withFileDestination(FileDestination fileDestination) {
        this.fileDestination = fileDestination;
        return this;
    }

    public NotificationProperties notification() {
        return this.notification;
    }

    public ScheduledActionProperties withNotification(NotificationProperties notification) {
        this.notification = notification;
        return this;
    }

    public String notificationEmail() {
        return this.notificationEmail;
    }

    public ScheduledActionProperties withNotificationEmail(String notificationEmail) {
        this.notificationEmail = notificationEmail;
        return this;
    }

    public ScheduleProperties schedule() {
        return this.schedule;
    }

    public ScheduledActionProperties withSchedule(ScheduleProperties schedule) {
        this.schedule = schedule;
        return this;
    }

    public String scope() {
        return this.scope;
    }

    public ScheduledActionProperties withScope(String scope) {
        this.scope = scope;
        return this;
    }

    public ScheduledActionStatus status() {
        return this.status;
    }

    public ScheduledActionProperties withStatus(ScheduledActionStatus status) {
        this.status = status;
        return this;
    }

    public String viewId() {
        return this.viewId;
    }

    public ScheduledActionProperties withViewId(String viewId) {
        this.viewId = viewId;
        return this;
    }

    public void validate() {
        if (this.displayName() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property displayName in model ScheduledActionProperties"));
        }
        if (this.fileDestination() != null) {
            this.fileDestination().validate();
        }
        if (this.notification() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property notification in model ScheduledActionProperties"));
        }
        this.notification().validate();
        if (this.schedule() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property schedule in model ScheduledActionProperties"));
        }
        this.schedule().validate();
        if (this.status() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property status in model ScheduledActionProperties"));
        }
        if (this.viewId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property viewId in model ScheduledActionProperties"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeJsonField("notification", (JsonSerializable)this.notification);
        jsonWriter.writeJsonField("schedule", (JsonSerializable)this.schedule);
        jsonWriter.writeStringField("status", this.status == null ? null : this.status.toString());
        jsonWriter.writeStringField("viewId", this.viewId);
        jsonWriter.writeJsonField("fileDestination", (JsonSerializable)this.fileDestination);
        jsonWriter.writeStringField("notificationEmail", this.notificationEmail);
        jsonWriter.writeStringField("scope", this.scope);
        return jsonWriter.writeEndObject();
    }

    public static ScheduledActionProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ScheduledActionProperties)jsonReader.readObject(reader -> {
            ScheduledActionProperties deserializedScheduledActionProperties = new ScheduledActionProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("displayName".equals(fieldName)) {
                    deserializedScheduledActionProperties.displayName = reader.getString();
                    continue;
                }
                if ("notification".equals(fieldName)) {
                    deserializedScheduledActionProperties.notification = NotificationProperties.fromJson(reader);
                    continue;
                }
                if ("schedule".equals(fieldName)) {
                    deserializedScheduledActionProperties.schedule = ScheduleProperties.fromJson(reader);
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedScheduledActionProperties.status = ScheduledActionStatus.fromString(reader.getString());
                    continue;
                }
                if ("viewId".equals(fieldName)) {
                    deserializedScheduledActionProperties.viewId = reader.getString();
                    continue;
                }
                if ("fileDestination".equals(fieldName)) {
                    deserializedScheduledActionProperties.fileDestination = FileDestination.fromJson(reader);
                    continue;
                }
                if ("notificationEmail".equals(fieldName)) {
                    deserializedScheduledActionProperties.notificationEmail = reader.getString();
                    continue;
                }
                if ("scope".equals(fieldName)) {
                    deserializedScheduledActionProperties.scope = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedScheduledActionProperties;
        });
    }
}

