/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.costmanagement.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.costmanagement.fluent.models.ViewProperties;
import com.azure.resourcemanager.costmanagement.models.AccumulatedType;
import com.azure.resourcemanager.costmanagement.models.ChartType;
import com.azure.resourcemanager.costmanagement.models.CostManagementProxyResource;
import com.azure.resourcemanager.costmanagement.models.KpiProperties;
import com.azure.resourcemanager.costmanagement.models.MetricType;
import com.azure.resourcemanager.costmanagement.models.PivotProperties;
import com.azure.resourcemanager.costmanagement.models.ReportConfigDataset;
import com.azure.resourcemanager.costmanagement.models.ReportConfigTimePeriod;
import com.azure.resourcemanager.costmanagement.models.ReportTimeframeType;
import com.azure.resourcemanager.costmanagement.models.ReportType;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;

public final class ViewInner
extends CostManagementProxyResource {
    private ViewProperties innerProperties;
    private String type;
    private String name;
    private String id;

    private ViewProperties innerProperties() {
        return this.innerProperties;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public ViewInner withEtag(String etag) {
        super.withEtag(etag);
        return this;
    }

    public String displayName() {
        return this.innerProperties() == null ? null : this.innerProperties().displayName();
    }

    public ViewInner withDisplayName(String displayName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ViewProperties();
        }
        this.innerProperties().withDisplayName(displayName);
        return this;
    }

    public String scope() {
        return this.innerProperties() == null ? null : this.innerProperties().scope();
    }

    public ViewInner withScope(String scope) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ViewProperties();
        }
        this.innerProperties().withScope(scope);
        return this;
    }

    public OffsetDateTime createdOn() {
        return this.innerProperties() == null ? null : this.innerProperties().createdOn();
    }

    public OffsetDateTime modifiedOn() {
        return this.innerProperties() == null ? null : this.innerProperties().modifiedOn();
    }

    public String dateRange() {
        return this.innerProperties() == null ? null : this.innerProperties().dateRange();
    }

    public ViewInner withDateRange(String dateRange) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ViewProperties();
        }
        this.innerProperties().withDateRange(dateRange);
        return this;
    }

    public String currency() {
        return this.innerProperties() == null ? null : this.innerProperties().currency();
    }

    public ChartType chart() {
        return this.innerProperties() == null ? null : this.innerProperties().chart();
    }

    public ViewInner withChart(ChartType chart) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ViewProperties();
        }
        this.innerProperties().withChart(chart);
        return this;
    }

    public AccumulatedType accumulated() {
        return this.innerProperties() == null ? null : this.innerProperties().accumulated();
    }

    public ViewInner withAccumulated(AccumulatedType accumulated) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ViewProperties();
        }
        this.innerProperties().withAccumulated(accumulated);
        return this;
    }

    public MetricType metric() {
        return this.innerProperties() == null ? null : this.innerProperties().metric();
    }

    public ViewInner withMetric(MetricType metric) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ViewProperties();
        }
        this.innerProperties().withMetric(metric);
        return this;
    }

    public List<KpiProperties> kpis() {
        return this.innerProperties() == null ? null : this.innerProperties().kpis();
    }

    public ViewInner withKpis(List<KpiProperties> kpis) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ViewProperties();
        }
        this.innerProperties().withKpis(kpis);
        return this;
    }

    public List<PivotProperties> pivots() {
        return this.innerProperties() == null ? null : this.innerProperties().pivots();
    }

    public ViewInner withPivots(List<PivotProperties> pivots) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ViewProperties();
        }
        this.innerProperties().withPivots(pivots);
        return this;
    }

    public ReportType typePropertiesType() {
        return this.innerProperties() == null ? null : this.innerProperties().type();
    }

    public ViewInner withTypePropertiesType(ReportType type) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ViewProperties();
        }
        this.innerProperties().withType(type);
        return this;
    }

    public ReportTimeframeType timeframe() {
        return this.innerProperties() == null ? null : this.innerProperties().timeframe();
    }

    public ViewInner withTimeframe(ReportTimeframeType timeframe) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ViewProperties();
        }
        this.innerProperties().withTimeframe(timeframe);
        return this;
    }

    public ReportConfigTimePeriod timePeriod() {
        return this.innerProperties() == null ? null : this.innerProperties().timePeriod();
    }

    public ViewInner withTimePeriod(ReportConfigTimePeriod timePeriod) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ViewProperties();
        }
        this.innerProperties().withTimePeriod(timePeriod);
        return this;
    }

    public ReportConfigDataset dataSet() {
        return this.innerProperties() == null ? null : this.innerProperties().dataSet();
    }

    public ViewInner withDataSet(ReportConfigDataset dataSet) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ViewProperties();
        }
        this.innerProperties().withDataSet(dataSet);
        return this;
    }

    public Boolean includeMonetaryCommitment() {
        return this.innerProperties() == null ? null : this.innerProperties().includeMonetaryCommitment();
    }

    public ViewInner withIncludeMonetaryCommitment(Boolean includeMonetaryCommitment) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ViewProperties();
        }
        this.innerProperties().withIncludeMonetaryCommitment(includeMonetaryCommitment);
        return this;
    }

    @Override
    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("eTag", this.etag());
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static ViewInner fromJson(JsonReader jsonReader) throws IOException {
        return (ViewInner)((Object)jsonReader.readObject(reader -> {
            ViewInner deserializedViewInner = new ViewInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedViewInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedViewInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedViewInner.type = reader.getString();
                    continue;
                }
                if ("eTag".equals(fieldName)) {
                    deserializedViewInner.withEtag(reader.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedViewInner.innerProperties = ViewProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedViewInner;
        }));
    }
}

