/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.costmanagement.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.costmanagement.fluent.models.ReportConfigDefinition;
import com.azure.resourcemanager.costmanagement.models.AccumulatedType;
import com.azure.resourcemanager.costmanagement.models.ChartType;
import com.azure.resourcemanager.costmanagement.models.KpiProperties;
import com.azure.resourcemanager.costmanagement.models.MetricType;
import com.azure.resourcemanager.costmanagement.models.PivotProperties;
import com.azure.resourcemanager.costmanagement.models.ReportConfigDataset;
import com.azure.resourcemanager.costmanagement.models.ReportConfigTimePeriod;
import com.azure.resourcemanager.costmanagement.models.ReportTimeframeType;
import com.azure.resourcemanager.costmanagement.models.ReportType;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;

public final class ViewProperties
implements JsonSerializable<ViewProperties> {
    private String displayName;
    private String scope;
    private OffsetDateTime createdOn;
    private OffsetDateTime modifiedOn;
    private String dateRange;
    private String currency;
    private ReportConfigDefinition innerQuery;
    private ChartType chart;
    private AccumulatedType accumulated;
    private MetricType metric;
    private List<KpiProperties> kpis;
    private List<PivotProperties> pivots;

    public String displayName() {
        return this.displayName;
    }

    public ViewProperties withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    public String scope() {
        return this.scope;
    }

    public ViewProperties withScope(String scope) {
        this.scope = scope;
        return this;
    }

    public OffsetDateTime createdOn() {
        return this.createdOn;
    }

    public OffsetDateTime modifiedOn() {
        return this.modifiedOn;
    }

    public String dateRange() {
        return this.dateRange;
    }

    public ViewProperties withDateRange(String dateRange) {
        this.dateRange = dateRange;
        return this;
    }

    public String currency() {
        return this.currency;
    }

    private ReportConfigDefinition innerQuery() {
        return this.innerQuery;
    }

    public ChartType chart() {
        return this.chart;
    }

    public ViewProperties withChart(ChartType chart) {
        this.chart = chart;
        return this;
    }

    public AccumulatedType accumulated() {
        return this.accumulated;
    }

    public ViewProperties withAccumulated(AccumulatedType accumulated) {
        this.accumulated = accumulated;
        return this;
    }

    public MetricType metric() {
        return this.metric;
    }

    public ViewProperties withMetric(MetricType metric) {
        this.metric = metric;
        return this;
    }

    public List<KpiProperties> kpis() {
        return this.kpis;
    }

    public ViewProperties withKpis(List<KpiProperties> kpis) {
        this.kpis = kpis;
        return this;
    }

    public List<PivotProperties> pivots() {
        return this.pivots;
    }

    public ViewProperties withPivots(List<PivotProperties> pivots) {
        this.pivots = pivots;
        return this;
    }

    public ReportType type() {
        return this.innerQuery() == null ? null : this.innerQuery().type();
    }

    public ViewProperties withType(ReportType type) {
        if (this.innerQuery() == null) {
            this.innerQuery = new ReportConfigDefinition();
        }
        this.innerQuery().withType(type);
        return this;
    }

    public ReportTimeframeType timeframe() {
        return this.innerQuery() == null ? null : this.innerQuery().timeframe();
    }

    public ViewProperties withTimeframe(ReportTimeframeType timeframe) {
        if (this.innerQuery() == null) {
            this.innerQuery = new ReportConfigDefinition();
        }
        this.innerQuery().withTimeframe(timeframe);
        return this;
    }

    public ReportConfigTimePeriod timePeriod() {
        return this.innerQuery() == null ? null : this.innerQuery().timePeriod();
    }

    public ViewProperties withTimePeriod(ReportConfigTimePeriod timePeriod) {
        if (this.innerQuery() == null) {
            this.innerQuery = new ReportConfigDefinition();
        }
        this.innerQuery().withTimePeriod(timePeriod);
        return this;
    }

    public ReportConfigDataset dataSet() {
        return this.innerQuery() == null ? null : this.innerQuery().dataSet();
    }

    public ViewProperties withDataSet(ReportConfigDataset dataSet) {
        if (this.innerQuery() == null) {
            this.innerQuery = new ReportConfigDefinition();
        }
        this.innerQuery().withDataSet(dataSet);
        return this;
    }

    public Boolean includeMonetaryCommitment() {
        return this.innerQuery() == null ? null : this.innerQuery().includeMonetaryCommitment();
    }

    public ViewProperties withIncludeMonetaryCommitment(Boolean includeMonetaryCommitment) {
        if (this.innerQuery() == null) {
            this.innerQuery = new ReportConfigDefinition();
        }
        this.innerQuery().withIncludeMonetaryCommitment(includeMonetaryCommitment);
        return this;
    }

    public void validate() {
        if (this.innerQuery() != null) {
            this.innerQuery().validate();
        }
        if (this.kpis() != null) {
            this.kpis().forEach(e -> e.validate());
        }
        if (this.pivots() != null) {
            this.pivots().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeStringField("scope", this.scope);
        jsonWriter.writeStringField("dateRange", this.dateRange);
        jsonWriter.writeJsonField("query", (JsonSerializable)this.innerQuery);
        jsonWriter.writeStringField("chart", this.chart == null ? null : this.chart.toString());
        jsonWriter.writeStringField("accumulated", this.accumulated == null ? null : this.accumulated.toString());
        jsonWriter.writeStringField("metric", this.metric == null ? null : this.metric.toString());
        jsonWriter.writeArrayField("kpis", this.kpis, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("pivots", this.pivots, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static ViewProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ViewProperties)jsonReader.readObject(reader -> {
            ViewProperties deserializedViewProperties = new ViewProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("displayName".equals(fieldName)) {
                    deserializedViewProperties.displayName = reader.getString();
                    continue;
                }
                if ("scope".equals(fieldName)) {
                    deserializedViewProperties.scope = reader.getString();
                    continue;
                }
                if ("createdOn".equals(fieldName)) {
                    deserializedViewProperties.createdOn = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("modifiedOn".equals(fieldName)) {
                    deserializedViewProperties.modifiedOn = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("dateRange".equals(fieldName)) {
                    deserializedViewProperties.dateRange = reader.getString();
                    continue;
                }
                if ("currency".equals(fieldName)) {
                    deserializedViewProperties.currency = reader.getString();
                    continue;
                }
                if ("query".equals(fieldName)) {
                    deserializedViewProperties.innerQuery = ReportConfigDefinition.fromJson(reader);
                    continue;
                }
                if ("chart".equals(fieldName)) {
                    deserializedViewProperties.chart = ChartType.fromString(reader.getString());
                    continue;
                }
                if ("accumulated".equals(fieldName)) {
                    deserializedViewProperties.accumulated = AccumulatedType.fromString(reader.getString());
                    continue;
                }
                if ("metric".equals(fieldName)) {
                    deserializedViewProperties.metric = MetricType.fromString(reader.getString());
                    continue;
                }
                if ("kpis".equals(fieldName)) {
                    List kpis;
                    deserializedViewProperties.kpis = kpis = reader.readArray(reader1 -> KpiProperties.fromJson(reader1));
                    continue;
                }
                if ("pivots".equals(fieldName)) {
                    List pivots;
                    deserializedViewProperties.pivots = pivots = reader.readArray(reader1 -> PivotProperties.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedViewProperties;
        });
    }
}

