/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.costmanagement.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.costmanagement.fluent.AlertsClient;
import com.azure.resourcemanager.costmanagement.fluent.models.AlertInner;
import com.azure.resourcemanager.costmanagement.fluent.models.AlertsResultInner;
import com.azure.resourcemanager.costmanagement.implementation.CostManagementClientImpl;
import com.azure.resourcemanager.costmanagement.models.DismissAlertPayload;
import com.azure.resourcemanager.costmanagement.models.ExternalCloudProviderType;
import reactor.core.publisher.Mono;

public final class AlertsClientImpl
implements AlertsClient {
    private final AlertsService service;
    private final CostManagementClientImpl client;

    AlertsClientImpl(CostManagementClientImpl client) {
        this.service = (AlertsService)RestProxy.create(AlertsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<AlertsResultInner>> listWithResponseAsync(String scope) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), this.client.getApiVersion(), scope, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<AlertsResultInner>> listWithResponseAsync(String scope, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), this.client.getApiVersion(), scope, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<AlertsResultInner> listAsync(String scope) {
        return this.listWithResponseAsync(scope).flatMap(res -> Mono.justOrEmpty((Object)((AlertsResultInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<AlertsResultInner> listWithResponse(String scope, Context context) {
        return (Response)this.listWithResponseAsync(scope, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public AlertsResultInner list(String scope) {
        return (AlertsResultInner)this.listWithResponse(scope, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<AlertInner>> getWithResponseAsync(String scope, String alertId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (alertId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter alertId is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), this.client.getApiVersion(), scope, alertId, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<AlertInner>> getWithResponseAsync(String scope, String alertId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (alertId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter alertId is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), this.client.getApiVersion(), scope, alertId, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<AlertInner> getAsync(String scope, String alertId) {
        return this.getWithResponseAsync(scope, alertId).flatMap(res -> Mono.justOrEmpty((Object)((Object)((AlertInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<AlertInner> getWithResponse(String scope, String alertId, Context context) {
        return (Response)this.getWithResponseAsync(scope, alertId, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public AlertInner get(String scope, String alertId) {
        return (AlertInner)((Object)this.getWithResponse(scope, alertId, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<AlertInner>> dismissWithResponseAsync(String scope, String alertId, DismissAlertPayload parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (alertId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter alertId is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.dismiss(this.client.getEndpoint(), this.client.getApiVersion(), scope, alertId, parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<AlertInner>> dismissWithResponseAsync(String scope, String alertId, DismissAlertPayload parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (alertId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter alertId is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.dismiss(this.client.getEndpoint(), this.client.getApiVersion(), scope, alertId, parameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<AlertInner> dismissAsync(String scope, String alertId, DismissAlertPayload parameters) {
        return this.dismissWithResponseAsync(scope, alertId, parameters).flatMap(res -> Mono.justOrEmpty((Object)((Object)((AlertInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<AlertInner> dismissWithResponse(String scope, String alertId, DismissAlertPayload parameters, Context context) {
        return (Response)this.dismissWithResponseAsync(scope, alertId, parameters, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public AlertInner dismiss(String scope, String alertId, DismissAlertPayload parameters) {
        return (AlertInner)((Object)this.dismissWithResponse(scope, alertId, parameters, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<AlertsResultInner>> listExternalWithResponseAsync(ExternalCloudProviderType externalCloudProviderType, String externalCloudProviderId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (externalCloudProviderType == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter externalCloudProviderType is required and cannot be null."));
        }
        if (externalCloudProviderId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter externalCloudProviderId is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listExternal(this.client.getEndpoint(), this.client.getApiVersion(), externalCloudProviderType, externalCloudProviderId, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<AlertsResultInner>> listExternalWithResponseAsync(ExternalCloudProviderType externalCloudProviderType, String externalCloudProviderId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (externalCloudProviderType == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter externalCloudProviderType is required and cannot be null."));
        }
        if (externalCloudProviderId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter externalCloudProviderId is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listExternal(this.client.getEndpoint(), this.client.getApiVersion(), externalCloudProviderType, externalCloudProviderId, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<AlertsResultInner> listExternalAsync(ExternalCloudProviderType externalCloudProviderType, String externalCloudProviderId) {
        return this.listExternalWithResponseAsync(externalCloudProviderType, externalCloudProviderId).flatMap(res -> Mono.justOrEmpty((Object)((AlertsResultInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<AlertsResultInner> listExternalWithResponse(ExternalCloudProviderType externalCloudProviderType, String externalCloudProviderId, Context context) {
        return (Response)this.listExternalWithResponseAsync(externalCloudProviderType, externalCloudProviderId, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public AlertsResultInner listExternal(ExternalCloudProviderType externalCloudProviderType, String externalCloudProviderId) {
        return (AlertsResultInner)this.listExternalWithResponse(externalCloudProviderType, externalCloudProviderId, Context.NONE).getValue();
    }

    @Host(value="{$host}")
    @ServiceInterface(name="CostManagementClient")
    public static interface AlertsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/{scope}/providers/Microsoft.CostManagement/alerts")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<AlertsResultInner>> list(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="scope", encoded=true) String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/{scope}/providers/Microsoft.CostManagement/alerts/{alertId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<AlertInner>> get(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="scope", encoded=true) String var3, @PathParam(value="alertId", encoded=true) String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/{scope}/providers/Microsoft.CostManagement/alerts/{alertId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<AlertInner>> dismiss(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="scope", encoded=true) String var3, @PathParam(value="alertId", encoded=true) String var4, @BodyParam(value="application/json") DismissAlertPayload var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/providers/Microsoft.CostManagement/{externalCloudProviderType}/{externalCloudProviderId}/alerts")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<AlertsResultInner>> listExternal(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="externalCloudProviderType") ExternalCloudProviderType var3, @PathParam(value="externalCloudProviderId") String var4, @HeaderParam(value="Accept") String var5, Context var6);
    }
}

