/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.costmanagement.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.costmanagement.CostManagementManager;
import com.azure.resourcemanager.costmanagement.fluent.AlertsClient;
import com.azure.resourcemanager.costmanagement.fluent.models.AlertInner;
import com.azure.resourcemanager.costmanagement.fluent.models.AlertsResultInner;
import com.azure.resourcemanager.costmanagement.implementation.AlertImpl;
import com.azure.resourcemanager.costmanagement.implementation.AlertsResultImpl;
import com.azure.resourcemanager.costmanagement.models.Alert;
import com.azure.resourcemanager.costmanagement.models.Alerts;
import com.azure.resourcemanager.costmanagement.models.AlertsResult;
import com.azure.resourcemanager.costmanagement.models.DismissAlertPayload;
import com.azure.resourcemanager.costmanagement.models.ExternalCloudProviderType;

public final class AlertsImpl
implements Alerts {
    private static final ClientLogger LOGGER = new ClientLogger(AlertsImpl.class);
    private final AlertsClient innerClient;
    private final CostManagementManager serviceManager;

    public AlertsImpl(AlertsClient innerClient, CostManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<AlertsResult> listWithResponse(String scope, Context context) {
        Response<AlertsResultInner> inner = this.serviceClient().listWithResponse(scope, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new AlertsResultImpl((AlertsResultInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public AlertsResult list(String scope) {
        AlertsResultInner inner = this.serviceClient().list(scope);
        if (inner != null) {
            return new AlertsResultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Alert> getWithResponse(String scope, String alertId, Context context) {
        Response<AlertInner> inner = this.serviceClient().getWithResponse(scope, alertId, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new AlertImpl((AlertInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public Alert get(String scope, String alertId) {
        AlertInner inner = this.serviceClient().get(scope, alertId);
        if (inner != null) {
            return new AlertImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Alert> dismissWithResponse(String scope, String alertId, DismissAlertPayload parameters, Context context) {
        Response<AlertInner> inner = this.serviceClient().dismissWithResponse(scope, alertId, parameters, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new AlertImpl((AlertInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public Alert dismiss(String scope, String alertId, DismissAlertPayload parameters) {
        AlertInner inner = this.serviceClient().dismiss(scope, alertId, parameters);
        if (inner != null) {
            return new AlertImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<AlertsResult> listExternalWithResponse(ExternalCloudProviderType externalCloudProviderType, String externalCloudProviderId, Context context) {
        Response<AlertsResultInner> inner = this.serviceClient().listExternalWithResponse(externalCloudProviderType, externalCloudProviderId, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new AlertsResultImpl((AlertsResultInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public AlertsResult listExternal(ExternalCloudProviderType externalCloudProviderType, String externalCloudProviderId) {
        AlertsResultInner inner = this.serviceClient().listExternal(externalCloudProviderType, externalCloudProviderId);
        if (inner != null) {
            return new AlertsResultImpl(inner, this.manager());
        }
        return null;
    }

    private AlertsClient serviceClient() {
        return this.innerClient;
    }

    private CostManagementManager manager() {
        return this.serviceManager;
    }
}

