/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.costmanagement.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.costmanagement.fluent.BenefitRecommendationsClient;
import com.azure.resourcemanager.costmanagement.fluent.models.BenefitRecommendationModelInner;
import com.azure.resourcemanager.costmanagement.implementation.CostManagementClientImpl;
import com.azure.resourcemanager.costmanagement.models.BenefitRecommendationsListResult;
import reactor.core.publisher.Mono;

public final class BenefitRecommendationsClientImpl
implements BenefitRecommendationsClient {
    private final BenefitRecommendationsService service;
    private final CostManagementClientImpl client;

    BenefitRecommendationsClientImpl(CostManagementClientImpl client) {
        this.service = (BenefitRecommendationsService)RestProxy.create(BenefitRecommendationsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<BenefitRecommendationModelInner>> listSinglePageAsync(String billingScope, String filter, String orderby, String expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (billingScope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter billingScope is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), filter, orderby, expand, this.client.getApiVersion(), billingScope, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((BenefitRecommendationsListResult)res.getValue()).value(), ((BenefitRecommendationsListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<BenefitRecommendationModelInner>> listSinglePageAsync(String billingScope, String filter, String orderby, String expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (billingScope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter billingScope is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), filter, orderby, expand, this.client.getApiVersion(), billingScope, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((BenefitRecommendationsListResult)res.getValue()).value(), ((BenefitRecommendationsListResult)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<BenefitRecommendationModelInner> listAsync(String billingScope, String filter, String orderby, String expand) {
        return new PagedFlux(() -> this.listSinglePageAsync(billingScope, filter, orderby, expand), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<BenefitRecommendationModelInner> listAsync(String billingScope) {
        String filter = null;
        String orderby = null;
        String expand = null;
        return new PagedFlux(() -> this.listSinglePageAsync(billingScope, filter, orderby, expand), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<BenefitRecommendationModelInner> listAsync(String billingScope, String filter, String orderby, String expand, Context context) {
        return new PagedFlux(() -> this.listSinglePageAsync(billingScope, filter, orderby, expand, context), nextLink -> this.listNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BenefitRecommendationModelInner> list(String billingScope) {
        String filter = null;
        String orderby = null;
        String expand = null;
        return new PagedIterable(this.listAsync(billingScope, filter, orderby, expand));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BenefitRecommendationModelInner> list(String billingScope, String filter, String orderby, String expand, Context context) {
        return new PagedIterable(this.listAsync(billingScope, filter, orderby, expand, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<BenefitRecommendationModelInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((BenefitRecommendationsListResult)res.getValue()).value(), ((BenefitRecommendationsListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<BenefitRecommendationModelInner>> listNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((BenefitRecommendationsListResult)res.getValue()).value(), ((BenefitRecommendationsListResult)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="CostManagementClient")
    public static interface BenefitRecommendationsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/{billingScope}/providers/Microsoft.CostManagement/benefitRecommendations")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<BenefitRecommendationsListResult>> list(@HostParam(value="$host") String var1, @QueryParam(value="$filter") String var2, @QueryParam(value="$orderby") String var3, @QueryParam(value="$expand") String var4, @QueryParam(value="api-version") String var5, @PathParam(value="billingScope", encoded=true) String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<BenefitRecommendationsListResult>> listNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

